/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.EditButton;
import sonar.fluxnetworks.client.gui.popup.PopupConnectionEdit;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabConnections
extends GuiTabPages<IFluxDevice> {
    public final LinkedHashSet<IFluxDevice> mSelected = new LinkedHashSet();
    public boolean mSelectionMode;
    public EditButton mMultiselect;
    public EditButton mEdit;
    public EditButton mDisconnect;
    private int timer = 0;

    public GuiTabConnections(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mGridHeight = 19;
        this.mGridPerPage = 7;
        this.mElementWidth = 146;
        this.mElementHeight = 18;
        if (this.getNetwork().isValid()) {
            ClientMessages.updateNetwork(this.getToken(), this.getNetwork(), (byte)23);
        }
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_CONNECTION;
    }

    @Override
    public void init() {
        super.init();
        this.mGridStartX = this.leftPos + 15;
        this.mGridStartY = this.topPos + 22;
        if (this.getNetwork().isValid()) {
            this.mMultiselect = new EditButton(this, this.leftPos + 146, this.topPos + 9, 128, 64, FluxTranslate.BATCH_CLEAR_BUTTON.get(), FluxTranslate.BATCH_SELECT_BUTTON.get());
            this.mEdit = new EditButton(this, this.leftPos + 118, this.topPos + 9, 192, 192, FluxTranslate.BATCH_EDIT_BUTTON.get(), FluxTranslate.BATCH_EDIT_BUTTON.get());
            this.mEdit.setClickable(false);
            this.mDisconnect = new EditButton(this, this.leftPos + 132, this.topPos + 9, 0, 0, FluxTranslate.BATCH_DISCONNECT_BUTTON.get(), FluxTranslate.BATCH_DISCONNECT_BUTTON.get());
            this.mDisconnect.setClickable(false);
            this.mButtons.add(this.mMultiselect);
            this.mButtons.add(this.mEdit);
            this.mButtons.add(this.mDisconnect);
        }
        this.refreshPages(this.getNetwork().getAllConnections());
    }

    @Override
    protected void drawBackgroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid()) {
            if (this.mSelectionMode) {
                gr.drawString(this.font, FluxTranslate.SELECTED.format(ChatFormatting.AQUA.toString() + this.mSelected.size() + String.valueOf(ChatFormatting.RESET)), this.leftPos + 20, this.topPos + 10, 0xFFFFFF);
            } else {
                gr.drawString(this.font, FluxTranslate.SORT_BY.get() + ": " + String.valueOf(ChatFormatting.AQUA) + FluxTranslate.SORTING_SMART.get(), this.leftPos + 19, this.topPos + 10, 0xFFFFFF);
            }
        } else {
            this.renderNavigationPrompt(gr, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    public void renderElement(GuiGraphics gr, IFluxDevice element, int x, int y) {
        int titleY;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
        int color = element.getDeviceType().mColor;
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        int textColor = 0xFFFFFF;
        if (this.mSelectionMode) {
            if (this.mSelected.contains(element)) {
                gr.fill(x - 5, y + 1, x - 3, y + this.mElementHeight - 1, -855638017);
                gr.fill(x + this.mElementWidth + 3, y + 1, x + this.mElementWidth + 5, y + this.mElementHeight - 1, -855638017);
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            } else {
                gr.fill(x - 5, y + 1, x - 3, y + this.mElementHeight - 1, -1436524448);
                gr.fill(x + this.mElementWidth + 3, y + 1, x + this.mElementWidth + 5, y + this.mElementHeight - 1, -1436524448);
                RenderSystem.setShaderColor((float)(r * 0.5f), (float)(g * 0.5f), (float)(b * 0.5f), (float)1.0f);
                textColor = 0xD0D0D0;
            }
        } else {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        }
        GuiTabConnections.blitF(gr, x, y, this.mElementWidth, this.mElementHeight, 0.0f, 384.0f, this.mElementWidth * 2, this.mElementHeight * 2);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (element.isChunkLoaded()) {
            gr.pose().pushPose();
            gr.pose().scale(0.75f, 0.75f, 1.0f);
            gr.drawString(this.font, FluxUtils.getTransferInfo(element, EnergyType.FE), (float)(x + 20) / 0.75f, (float)(y + 10) / 0.75f, textColor, true);
            gr.pose().popPose();
            titleY = y + 2;
        } else {
            textColor = 0x808080;
            titleY = y + 5;
        }
        if (element.getCustomName().isEmpty()) {
            gr.drawString(this.font, Language.getInstance().getOrDefault(element.getDisplayStack().getItem().getDescriptionId()), x + 20, titleY, textColor);
        } else {
            gr.drawString(this.font, element.getCustomName(), x + 21, titleY, textColor);
        }
        this.renderItemStack(gr, element.getDisplayStack(), x + 2, y + 1);
    }

    @Override
    public void renderElementTooltip(GuiGraphics gr, IFluxDevice element, int mouseX, int mouseY) {
        gr.renderComponentTooltip(this.font, this.getElementTooltips(element), mouseX, mouseY);
    }

    protected List<Component> getElementTooltips(@Nonnull IFluxDevice element) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (element.getCustomName().isEmpty()) {
            components.add((Component)Component.empty().withStyle(ChatFormatting.BOLD).append(element.getDisplayStack().getHoverName()));
        } else {
            components.add((Component)Component.literal((String)element.getCustomName()).withStyle(ChatFormatting.BOLD));
        }
        if (element.isChunkLoaded()) {
            if (element.isForcedLoading()) {
                components.add((Component)FluxTranslate.FORCED_LOADING.makeComponent().withStyle(ChatFormatting.AQUA));
            }
            components.add((Component)Component.literal((String)FluxUtils.getTransferInfo(element, EnergyType.FE)));
        } else {
            components.add((Component)FluxTranslate.CHUNK_UNLOADED.makeComponent().withStyle(ChatFormatting.RED));
        }
        if (element.getDeviceType().isStorage()) {
            components.add((Component)Component.literal((String)(FluxTranslate.ENERGY_STORED.get() + ": " + String.valueOf(ChatFormatting.BLUE) + EnergyType.FE.getStorage(element.getTransferBuffer()))));
        } else {
            components.add((Component)Component.literal((String)(FluxTranslate.INTERNAL_BUFFER.get() + ": " + String.valueOf(ChatFormatting.BLUE) + EnergyType.FE.getStorage(element.getTransferBuffer()))));
        }
        components.add((Component)Component.literal((String)(FluxTranslate.TRANSFER_LIMIT.get() + ": " + String.valueOf(ChatFormatting.GREEN) + (element.getDisableLimit() ? FluxTranslate.UNLIMITED.get() : EnergyType.FE.getStorage(element.getRawLimit())))));
        components.add((Component)Component.literal((String)(FluxTranslate.PRIORITY.get() + ": " + String.valueOf(ChatFormatting.GREEN) + String.valueOf(element.getSurgeMode() ? FluxTranslate.SURGE.get() : Integer.valueOf(element.getRawPriority())))));
        components.add((Component)Component.literal((String)FluxUtils.getDisplayPos(element.getGlobalPos())).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.literal((String)FluxUtils.getDisplayDim(element.getGlobalPos())).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        return components;
    }

    @Override
    protected void onElementClicked(IFluxDevice element, int mouseButton) {
        if (this.mSelectionMode && (mouseButton == 0 || mouseButton == 1)) {
            if (this.mSelected.remove(element)) {
                if (this.mSelected.isEmpty()) {
                    this.mEdit.setClickable(false);
                    this.mDisconnect.setClickable(false);
                }
            } else if (element.isChunkLoaded()) {
                this.mSelected.add(element);
                this.mEdit.setClickable(true);
                this.mDisconnect.setClickable(true);
            }
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof EditButton) {
            if (button == this.mMultiselect) {
                if (this.mMultiselect.isChecked()) {
                    this.mMultiselect.setChecked(false);
                    this.mSelectionMode = false;
                } else {
                    this.mMultiselect.setChecked(true);
                    this.mSelectionMode = true;
                }
                this.mSelected.clear();
                this.mEdit.setClickable(false);
                this.mDisconnect.setClickable(false);
            } else if (button == this.mEdit) {
                assert (this.mSelectionMode && !this.mSelected.isEmpty());
                this.openPopup(new PopupConnectionEdit(this));
            } else if (button == this.mDisconnect) {
                assert (this.mSelectionMode && !this.mSelected.isEmpty());
                ClientMessages.disconnect(this.getToken(), this.getNetwork(), this.mSelected);
                this.mDisconnect.setClickable(false);
            }
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.getNetwork().isValid()) {
            return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
        }
        return false;
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (key == 8) {
            this.refreshPages(this.getNetwork().getAllConnections());
        } else if (code == -1) {
            this.closePopup();
            if (key == 10) {
                if (this.mSelected.stream().anyMatch(f -> f.getGlobalPos().equals((Object)((IFluxDevice)((FluxMenu)this.menu).mProvider).getGlobalPos()))) {
                    this.switchTab(EnumNavigationTab.TAB_HOME, false);
                    return;
                }
                this.mElements.removeAll(this.mSelected);
                this.refreshCurrentPage();
            }
            this.mSelected.clear();
            this.mSelectionMode = false;
            this.mMultiselect.setChecked(false);
            this.mEdit.setClickable(false);
            this.mDisconnect.setClickable(false);
        }
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.timer = (this.timer + 1) % 20;
        if (this.getCurrentPopup() == null && this.timer % 5 == 0) {
            ClientMessages.updateConnections(this.getToken(), this.getNetwork(), this.mCurrent);
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        Comparator<IFluxDevice> comparator = Comparator.comparing(f -> !f.isChunkLoaded()).thenComparing(f -> f.getDeviceType().isStorage()).thenComparing(f -> f.getDeviceType().isPlug()).thenComparing(f -> f.getDeviceType().isPoint()).thenComparingInt(p -> -p.getRawPriority());
        this.mElements.sort(comparator);
    }
}

