/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.guide;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.guide.EnergyTooltip;

public class LytEnergy
extends LytBlock
implements InteractiveElement {
    private final int amount;
    private final int capacity;

    public LytEnergy(int amount, int capacity) {
        this.amount = amount;
        this.capacity = capacity;
    }

    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return new LytRect(x, y, 18, 56);
    }

    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    public void render(RenderContext context) {
        int x = this.bounds.x();
        int y = this.bounds.y();
        GuiGraphics gui = context.guiGraphics();
        WootContainerScreen.renderEnergyBg(gui, x, y);
        WootContainerScreen.renderEnergy(gui, x, y, this.amount, this.capacity);
    }

    public Optional<GuideTooltip> getTooltip(float x, float y) {
        if (this.amount <= 0) {
            return Optional.empty();
        }
        return Optional.of(new EnergyTooltip(this.amount));
    }
}

