/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.guide;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.MutableComponent;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.guide.ColorBarTooltip;

public class LytColorBar
extends LytBlock
implements InteractiveElement {
    private final int amount;
    private final int capacity;
    private final int color;
    private final MutableComponent colorName;

    public LytColorBar(int amount, int capacity, int color, MutableComponent colorName) {
        this.amount = amount;
        this.capacity = capacity;
        this.color = color;
        this.colorName = colorName;
    }

    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return new LytRect(x, y, 56, 11);
    }

    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    public void render(RenderContext context) {
        int x = this.bounds.x();
        int y = this.bounds.y();
        GuiGraphics gui = context.guiGraphics();
        WootContainerScreen.renderColorBarBg(gui, x, y, this.color);
        WootContainerScreen.renderColorBar(gui, x, y, this.amount, this.capacity, this.color);
    }

    public Optional<GuideTooltip> getTooltip(float x, float y) {
        if (this.amount <= 0) {
            return Optional.empty();
        }
        return Optional.of(new ColorBarTooltip(this.amount, this.colorName));
    }
}

