/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.guide;

import guideme.document.interaction.GuideTooltip;
import guideme.siteexport.ResourceExporter;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class FluidTooltip
implements GuideTooltip {
    private final FluidStack stack;

    public FluidTooltip(FluidStack stack) {
        this.stack = stack;
    }

    public ItemStack getIcon() {
        return this.stack.getFluid().getBucket().getDefaultInstance();
    }

    public List<ClientTooltipComponent> getLines() {
        List<MutableComponent> lines = List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.fluid").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)(!this.stack.isEmpty() ? this.stack.getHoverName() : Component.translatable((String)"info.woot_revived.empty"))), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(this.stack.getAmount())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
        return lines.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
    }

    public void exportResources(ResourceExporter exporter) {
        exporter.referenceFluid(this.stack.getFluid());
    }
}

