/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.guide;

import guideme.document.interaction.GuideTooltip;
import guideme.scene.level.GuidebookLevel;
import guideme.siteexport.ResourceExporter;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.util.common.WootTier;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class EntityTooltip
implements GuideTooltip {
    private final WootFactoryMob<?> mob;
    private final CompoundTag tag;
    private final GuidebookLevel level;

    public EntityTooltip(WootFactoryMob<?> mob, CompoundTag tag, GuidebookLevel level) {
        this.mob = mob;
        this.tag = tag;
        this.level = level;
    }

    public List<ClientTooltipComponent> getLines() {
        String modId = BuiltInRegistries.ENTITY_TYPE.getKey(this.mob.getEntityType()).getNamespace();
        List<MutableComponent> lines = List.of(this.mob.getDisplayName(this.tag, (HolderLookup.Provider)this.level.registryAccess()).append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.tier").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.translatable((String)WootTier.getTranslationKey(this.mob.getTier()))), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.rate").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(this.mob.getSpawnTickRate())).append((Component)Component.literal((String)"t").setStyle(WootStyles.UNIT_STYLE)), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.cost").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(this.mob.getVitalityFuelCost())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)), ModNameHelper.getModName(modId).setStyle(WootStyles.MOD_NAME_STYLE));
        return lines.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
    }

    public void exportResources(ResourceExporter exporter) {
    }
}

