/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.buttons;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class WootSidePropertyButton
extends WootButton {
    protected final OnPress onPress;
    public final MachineSide side;
    public final Direction facing;
    public MachineSideProperty property;

    public WootSidePropertyButton(int x, int y, MachineSide side, MachineSideProperty property, Direction facing, OnPress onPress) {
        super(x, y, 14, 14);
        this.onPress = onPress;
        this.side = side;
        this.property = property;
        this.facing = facing;
    }

    @Override
    protected void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        int uOffset;
        int n = this.property == MachineSideProperty.ENABLED ? 215 : (this.property == MachineSideProperty.DISABLED ? 230 : (uOffset = this.property == MachineSideProperty.PULL ? 215 : 230));
        int vOffset = this.property == MachineSideProperty.ENABLED ? 162 : (this.property == MachineSideProperty.DISABLED ? 162 : (this.property == MachineSideProperty.PULL ? 177 : 177));
        gui.blit(WootContainerScreen.GUI, this.getX(), this.getY(), uOffset, vOffset, this.getWidth(), this.getHeight());
        if (this.isHovered()) {
            gui.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, -2130706433);
            List<MutableComponent> tooltip = List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.direction").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)this.side.getComponent()).append(" ").append((Component)this.side.getDirectionComponent(this.facing)), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.action").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)this.property.getComponent()));
            gui.renderTooltip(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public MachineSideProperty nextProperty() {
        this.property = this.property.getNext();
        return this.property;
    }

    @Override
    public void onPress() {
        this.onPress.onPress(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(WootSidePropertyButton var1);
    }
}

