/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.buttons;

import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerScreen;

public class WootRedstoneButton
extends WootButton {
    protected final OnPress onPress;
    protected RedstoneMode mode;

    public WootRedstoneButton(int x, int y, RedstoneMode mode, OnPress onPress) {
        super(x, y, 14, 14);
        this.onPress = onPress;
        this.mode = mode;
    }

    @Override
    protected void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        if (this.active) {
            int uOffset;
            int n = this.mode == RedstoneMode.ALWAYS_ON ? 215 : (this.mode == RedstoneMode.WITH_NO_SIGNAL ? 230 : (uOffset = this.mode == RedstoneMode.WITH_SIGNAL ? 215 : 230));
            int vOffset = this.mode == RedstoneMode.ALWAYS_ON ? 132 : (this.mode == RedstoneMode.WITH_NO_SIGNAL ? 132 : (this.mode == RedstoneMode.WITH_SIGNAL ? 147 : 147));
            gui.blit(WootContainerScreen.GUI, this.getX(), this.getY(), uOffset, vOffset, this.getWidth(), this.getHeight());
            if (this.isHovered()) {
                gui.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, -2130706433);
                gui.renderTooltip(WootContainerScreen.getFont(), this.mode.getComponent(), mouseX, mouseY);
            }
        }
    }

    public RedstoneMode nextMode() {
        this.mode = this.mode.getNext();
        return this.mode;
    }

    public void setMode(RedstoneMode mode) {
        this.mode = mode;
    }

    @Override
    public void onPress() {
        this.onPress.onPress(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(WootRedstoneButton var1);
    }
}

