/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.recipes;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WootRecipeInput
implements RecipeInput {
    private final int size;
    private final NonNullList<Either<ItemStack, FluidStack>> ingredients;

    @SafeVarargs
    public WootRecipeInput(Either<ItemStack, FluidStack> ... ingredients) {
        this.size = ingredients.length;
        this.ingredients = NonNullList.of((Object)Either.left((Object)ItemStack.EMPTY), (Object[])ingredients);
    }

    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.ingredients.size() ? ((Either)this.ingredients.get(slot)).left().orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public FluidStack getFluid(int slot) {
        return slot >= 0 && slot < this.ingredients.size() ? ((Either)this.ingredients.get(slot)).right().orElse(FluidStack.EMPTY) : FluidStack.EMPTY;
    }

    public int size() {
        return this.size;
    }
}

