/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class WootImportItemHandler
implements IItemHandler {
    private final Map<Integer, List<ItemStack>> importItems = new HashMap<Integer, List<ItemStack>>();
    private final Map<Integer, List<Integer>> items = new HashMap<Integer, List<Integer>>();
    public static final Codec<WootImportItemHandler> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ItemStack.OPTIONAL_CODEC.listOf()).xmap(m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> new ArrayList((Collection)e.getValue()))), m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.toString((Integer)e.getKey()), Map.Entry::getValue))).fieldOf("ImportItems").forGetter(WootImportItemHandler::getImportItems), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT.listOf()).xmap(m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> new ArrayList((Collection)e.getValue()))), m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.toString((Integer)e.getKey()), Map.Entry::getValue))).fieldOf("Items").forGetter(WootImportItemHandler::getItems)).apply((Applicative)inst, WootImportItemHandler::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WootImportItemHandler> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new))), WootImportItemHandler::getImportItems, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.collection(ArrayList::new))), WootImportItemHandler::getItems, WootImportItemHandler::new);

    private Map<Integer, List<ItemStack>> getImportItems() {
        return this.importItems;
    }

    private Map<Integer, List<Integer>> getItems() {
        return this.items;
    }

    public int hashCode() {
        int h = 0;
        for (Map.Entry<Integer, List<ItemStack>> entry : this.importItems.entrySet()) {
            h += entry.getKey().hashCode();
            if (entry.getValue() == null) continue;
            for (ItemStack stack : entry.getValue()) {
                h += h * 31 + ItemStack.hashItemAndComponents((ItemStack)stack);
            }
        }
        return h + this.items.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WootImportItemHandler)) {
            return false;
        }
        WootImportItemHandler itemHandler = (WootImportItemHandler)obj;
        for (Map.Entry<Integer, List<ItemStack>> entry : this.importItems.entrySet()) {
            if (!itemHandler.importItems.containsKey(entry.getKey())) {
                return false;
            }
            List<ItemStack> list = itemHandler.importItems.get(entry.getKey());
            if (list.size() != entry.getValue().size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (ItemStack.isSameItemSameComponents((ItemStack)list.get(i), (ItemStack)entry.getValue().get(i))) continue;
                return false;
            }
        }
        return this.items.equals(itemHandler.items);
    }

    public WootImportItemHandler() {
    }

    private WootImportItemHandler(Map<Integer, List<ItemStack>> importItems, Map<Integer, List<Integer>> items) {
        this.importItems.putAll(importItems);
        this.items.putAll(items);
    }

    public void setImportItem(int index, List<ItemStack> importItem) {
        if (importItem == null) {
            if (this.importItems.containsKey(index)) {
                this.importItems.remove(index);
                this.items.remove(index);
            }
            return;
        }
        if (this.isEqual(this.importItems.get(index), importItem)) {
            return;
        }
        this.importItems.put(index, importItem);
        this.items.put(index, new ArrayList<Integer>(Collections.nCopies(importItem.size(), 0)));
    }

    private boolean isEqual(List<ItemStack> list1, List<ItemStack> list2) {
        if (list1 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            ItemStack item1 = list1.get(i);
            ItemStack item2 = list2.get(i);
            if (item1.getCount() != item2.getCount()) {
                return false;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)item1, (ItemStack)item2)) continue;
            return false;
        }
        return true;
    }

    public boolean isImportValid(int index) {
        List<ItemStack> list = this.importItems.get(index);
        if (list == null) {
            return true;
        }
        List<Integer> counts = this.items.get(index);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getCount() == counts.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    public void consume(int index) {
        List<Integer> counts = this.items.get(index);
        if (counts == null) {
            return;
        }
        Collections.fill(counts, 0);
    }

    public int getSlots() {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            for (ItemStack s : list) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(0, stack) || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            List<Integer> item = this.items.get(i);
            for (int j = 0; j < list.size(); ++j) {
                ItemStack s = list.get(j);
                if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack)) continue;
                int amount = item.get(j);
                int needToBeAdded = s.getCount() - amount;
                if (stack.getCount() <= needToBeAdded) {
                    if (!simulate) {
                        item.set(j, amount + stack.getCount());
                    }
                    return ItemStack.EMPTY;
                }
                if (!simulate) {
                    item.set(j, amount + needToBeAdded);
                }
                stack.shrink(needToBeAdded);
            }
        }
        return stack;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            for (ItemStack stack : list) {
                if (count >= stack.getCount()) continue;
                count = stack.getCount();
            }
        }
        return count;
    }
}

