/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class WootImportFluidHandler
implements IFluidHandler {
    private final Map<Integer, List<FluidStack>> importFluids = new HashMap<Integer, List<FluidStack>>();
    private final Map<Integer, List<Integer>> tanks = new HashMap<Integer, List<Integer>>();
    public static final Codec<WootImportFluidHandler> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)FluidStack.OPTIONAL_CODEC.listOf()).xmap(m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> new ArrayList((Collection)e.getValue()))), m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.toString((Integer)e.getKey()), Map.Entry::getValue))).fieldOf("ImportTanks").forGetter(WootImportFluidHandler::getImportFluids), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT.listOf()).xmap(m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), e -> new ArrayList((Collection)e.getValue()))), m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.toString((Integer)e.getKey()), Map.Entry::getValue))).fieldOf("Tanks").forGetter(WootImportFluidHandler::getInternalTanks)).apply((Applicative)inst, WootImportFluidHandler::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WootImportFluidHandler> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new))), WootImportFluidHandler::getImportFluids, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.collection(ArrayList::new))), WootImportFluidHandler::getInternalTanks, WootImportFluidHandler::new);

    private Map<Integer, List<FluidStack>> getImportFluids() {
        return this.importFluids;
    }

    private Map<Integer, List<Integer>> getInternalTanks() {
        return this.tanks;
    }

    public int hashCode() {
        int h = 0;
        for (Map.Entry<Integer, List<FluidStack>> entry : this.importFluids.entrySet()) {
            h += entry.getKey().hashCode();
            if (entry.getValue() == null) continue;
            for (FluidStack stack : entry.getValue()) {
                h += h * 31 + FluidStack.hashFluidAndComponents((FluidStack)stack);
            }
        }
        return h + this.tanks.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WootImportFluidHandler)) {
            return false;
        }
        WootImportFluidHandler fluidHandler = (WootImportFluidHandler)obj;
        for (Map.Entry<Integer, List<FluidStack>> entry : this.importFluids.entrySet()) {
            if (!fluidHandler.importFluids.containsKey(entry.getKey())) {
                return false;
            }
            List<FluidStack> list = fluidHandler.importFluids.get(entry.getKey());
            if (list.size() != entry.getValue().size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (FluidStack.isSameFluidSameComponents((FluidStack)list.get(i), (FluidStack)entry.getValue().get(i))) continue;
                return false;
            }
        }
        return this.tanks.equals(fluidHandler.tanks);
    }

    public WootImportFluidHandler() {
    }

    private WootImportFluidHandler(Map<Integer, List<FluidStack>> importFluids, Map<Integer, List<Integer>> tanks) {
        this.importFluids.putAll(importFluids);
        this.tanks.putAll(tanks);
    }

    public void setImportFluid(int index, List<FluidStack> importFluid) {
        if (importFluid == null) {
            if (this.importFluids.containsKey(index)) {
                this.importFluids.remove(index);
                this.tanks.remove(index);
            }
            return;
        }
        if (this.isEqual(this.importFluids.get(index), importFluid)) {
            return;
        }
        this.importFluids.put(index, importFluid);
        this.tanks.put(index, new ArrayList<Integer>(Collections.nCopies(importFluid.size(), 0)));
    }

    private boolean isEqual(List<FluidStack> list1, List<FluidStack> list2) {
        if (list1 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            FluidStack fluid1 = list1.get(i);
            FluidStack fluid2 = list2.get(i);
            if (fluid1.getAmount() != fluid2.getAmount()) {
                return false;
            }
            if (FluidStack.isSameFluidSameComponents((FluidStack)fluid1, (FluidStack)fluid2)) continue;
            return false;
        }
        return true;
    }

    public boolean isImportValid(int index) {
        List<FluidStack> list = this.importFluids.get(index);
        if (list == null) {
            return true;
        }
        List<Integer> amounts = this.tanks.get(index);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getAmount() == amounts.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    public void consume(int index) {
        List<Integer> amounts = this.tanks.get(index);
        if (amounts == null) {
            return;
        }
        Collections.fill(amounts, 0);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        int capacity = 0;
        for (int i = 0; i < 4; ++i) {
            List<FluidStack> list = this.importFluids.get(i);
            if (list == null) continue;
            for (FluidStack stack : list) {
                if (capacity >= stack.getAmount()) continue;
                capacity = stack.getAmount();
            }
        }
        return capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        for (int i = 0; i < 4; ++i) {
            List<FluidStack> list = this.importFluids.get(i);
            if (list == null) continue;
            for (FluidStack s : list) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)s, (FluidStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(0, resource) || resource.isEmpty()) {
            return 0;
        }
        resource = resource.copy();
        int filled = 0;
        for (int i = 0; i < 4; ++i) {
            List<FluidStack> list = this.importFluids.get(i);
            if (list == null) continue;
            List<Integer> tank = this.tanks.get(i);
            for (int j = 0; j < list.size(); ++j) {
                FluidStack stack = list.get(j);
                if (!FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)resource)) continue;
                int amount = tank.get(j);
                int needToBeFill = stack.getAmount() - amount;
                if (resource.getAmount() <= needToBeFill) {
                    filled += resource.getAmount();
                    if (!action.simulate()) {
                        tank.set(j, amount + resource.getAmount());
                    }
                    return filled;
                }
                filled += needToBeFill;
                if (!action.simulate()) {
                    tank.set(j, amount + needToBeFill);
                }
                resource.shrink(needToBeFill);
            }
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

