/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class WootFluidHandlerWrapper
implements IFluidHandler {
    private final List<FluidWrapper> fluidWrappers = new ArrayList<FluidWrapper>();

    public WootFluidHandlerWrapper addHandler(WootFluidTankHandler tank, Supplier<MachineSideProperty> property) {
        this.fluidWrappers.add(new FluidWrapper(tank, property));
        return this;
    }

    public int getTanks() {
        return this.fluidWrappers.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluidWrappers.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluidWrappers.get((int)tank).tank.getFluid();
    }

    public int getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.fluidWrappers.size()) {
            return 0;
        }
        return this.fluidWrappers.get((int)tank).tank.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (tank < 0 || tank >= this.fluidWrappers.size()) {
            return false;
        }
        return this.fluidWrappers.get((int)tank).tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        resource = resource.copy();
        int fill = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            WootFluidTankHandler tank = this.fluidWrappers.get((int)i).tank;
            MachineSideProperty property = this.fluidWrappers.get(i).property().get();
            if (tank.isOutput || !tank.isFluidValid(resource) || property == MachineSideProperty.DISABLED || property == MachineSideProperty.PUSH) continue;
            int filled = tank.fill(resource, action);
            resource.shrink(filled);
            fill += filled;
        }
        return fill;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack drained;
            MachineSideProperty property;
            WootFluidTankHandler tank = this.fluidWrappers.get((int)i).tank;
            if (tank.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)resource) || (property = this.fluidWrappers.get(i).property().get()) == MachineSideProperty.DISABLED || property == MachineSideProperty.PULL || (drained = tank.drain(resource, action)).isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.getTanks(); ++i) {
            MachineSideProperty property;
            WootFluidTankHandler tank = this.fluidWrappers.get((int)i).tank;
            if (tank.isEmpty() || (property = this.fluidWrappers.get(i).property().get()) == MachineSideProperty.DISABLED || property == MachineSideProperty.PULL) continue;
            return tank.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    private record FluidWrapper(WootFluidTankHandler tank, Supplier<MachineSideProperty> property) {
    }
}

