/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.energy.EnergyStorage;

public class WootEnergyStorage
extends EnergyStorage
implements INBTSerializable<Tag> {
    public WootEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    protected void onEnergyChanged() {
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.onEnergyChanged();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int res = super.receiveEnergy(maxReceive, simulate);
        this.onEnergyChanged();
        return res;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int res = super.extractEnergy(maxExtract, simulate);
        this.onEnergyChanged();
        return res;
    }

    public int internalExtractEnergy(int toExtract, boolean simulate) {
        if (toExtract <= 0) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, toExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.onEnergyChanged();
        }
        return energyExtracted;
    }
}

