/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WootConcatItemStack {
    final Item item;
    final DataComponentMap components;

    public WootConcatItemStack(Item item, DataComponentMap components) {
        this.item = item;
        this.components = components;
    }

    public int hashCode() {
        return Objects.hash(this.item, this.components);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WootConcatItemStack)) {
            return false;
        }
        WootConcatItemStack stack = (WootConcatItemStack)o;
        return this.item == stack.item && Objects.equals(this.components, stack.components);
    }

    public static List<ItemStack> merge(List<ItemStack> unconcatItems) {
        HashMap<WootConcatItemStack, ItemStack> map = new HashMap<WootConcatItemStack, ItemStack>();
        for (ItemStack itemStack : unconcatItems) {
            if (itemStack.isEmpty()) continue;
            WootConcatItemStack stack = new WootConcatItemStack(itemStack.getItem(), itemStack.getComponents());
            if (map.containsKey(stack)) {
                ItemStack existing = (ItemStack)map.get(stack);
                existing.grow(itemStack.getCount());
                continue;
            }
            map.put(stack, itemStack.copy());
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack itemStack : map.values()) {
            int maxStack = itemStack.getMaxStackSize();
            int count = itemStack.getCount();
            int stacks = count / maxStack;
            int rest = count % maxStack;
            itemStack.setCount(maxStack);
            for (int i = 0; i < stacks; ++i) {
                items.add(itemStack.copy());
            }
            if (rest == 0) continue;
            itemStack.setCount(rest);
            items.add(itemStack);
        }
        return items;
    }
}

