/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.common;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;

public class WootCodecs {
    public static Codec<List<EnumMap<MachineSide, MachineSideProperty>>> MACHINE_PROPERTIES_CODEC = Codec.unboundedMap((Codec)StringRepresentable.fromEnum(MachineSide::values), (Codec)StringRepresentable.fromEnum(MachineSideProperty::values)).xmap(m -> {
        EnumMap em = new EnumMap(MachineSide.class);
        em.putAll(m);
        return em;
    }, HashMap::new).listOf();
    public static StreamCodec<FriendlyByteBuf, List<EnumMap<MachineSide, MachineSideProperty>>> MACHINE_PROPERTIES_STREAM_CODEC = ByteBufCodecs.map(size -> new EnumMap(MachineSide.class), (StreamCodec)NeoForgeStreamCodecs.enumCodec(MachineSide.class), (StreamCodec)NeoForgeStreamCodecs.enumCodec(MachineSideProperty.class)).apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    public static final Codec<Float> NON_NEGATIVE_FLOAT = WootCodecs.floatRangeWithMessage(0.0f, Float.MAX_VALUE, f -> "Value must be non-negative: " + f);

    private static Codec<Float> floatRangeWithMessage(float min, float max, Function<Float, String> msg) {
        return Codec.FLOAT.validate(f -> f.compareTo(Float.valueOf(min)) >= 0 && f.compareTo(Float.valueOf(max)) <= 0 ? DataResult.success((Object)f) : DataResult.error(() -> (String)msg.apply((Float)f)));
    }
}

