/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.common;

import com.google.common.base.CaseFormat;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.render.WootStyles;

public enum MachineSideProperty implements StringRepresentable
{
    ENABLED,
    PUSH,
    PULL,
    DISABLED;


    public MachineSideProperty getNext() {
        if (this == ENABLED) {
            return PUSH;
        }
        if (this == PUSH) {
            return PULL;
        }
        if (this == PULL) {
            return DISABLED;
        }
        return ENABLED;
    }

    public MutableComponent getComponent() {
        MutableComponent component = Component.literal((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.toString()));
        if (this == ENABLED) {
            return component.setStyle(WootStyles.MACHINE_PROPERTY_ENABLED_STYLE);
        }
        if (this == PUSH) {
            return component.setStyle(WootStyles.MACHINE_PROPERTY_PUSH_STYLE);
        }
        if (this == PULL) {
            return component.setStyle(WootStyles.MACHINE_PROPERTY_PULL_STYLE);
        }
        return component.setStyle(WootStyles.MACHINE_PROPERTY_DISABLED_STYLE);
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

