/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.util.render.WootShapes;

public abstract class FactoryBlockBase
extends Block
implements EntityBlock {
    protected final Supplier<BlockEntityType<?>> entity;

    public FactoryBlockBase(Supplier<BlockEntityType<?>> entity, BlockBehaviour.Properties properties) {
        super(properties);
        this.entity = entity;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.ATTACHED});
        builder.add(new Property[]{BlockStateProperties.ENABLED});
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        return state;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.entity.get().create(pos, state);
    }

    public boolean verifyItem(Item item) {
        return item == this.asItem();
    }

    public static class State
    extends BlockState {
        public State(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public VoxelShape getShape(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            if (!((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return WootShapes.disabledShape;
            }
            if (((Boolean)this.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                return Shapes.block();
            }
            return WootShapes.nonAttachedShape;
        }

        @NotNull
        public RenderShape getRenderShape() {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() && ((Boolean)this.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                return RenderShape.MODEL;
            }
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }

        public float getDestroyProgress(@NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.getDestroyProgress(player, level, pos);
            }
            return 0.0f;
        }

        public boolean canSurvive(@NotNull LevelReader level, @NotNull BlockPos pos) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.canSurvive(level, pos);
            }
            return true;
        }

        @NotNull
        public PushReaction getPistonPushReaction() {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.getPistonPushReaction();
            }
            return PushReaction.BLOCK;
        }

        @NotNull
        public VoxelShape getCollisionShape(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.getCollisionShape(level, pos);
            }
            return Shapes.empty();
        }

        @NotNull
        public VoxelShape getCollisionShape(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.getCollisionShape(level, pos, context);
            }
            return Shapes.empty();
        }

        public boolean isRedstoneConductor(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            return this.hasProperty((Property)BlockStateProperties.ATTACHED) && (Boolean)this.getValue((Property)BlockStateProperties.ATTACHED) != false;
        }

        public boolean isSuffocating(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.isSuffocating(level, pos);
            }
            return false;
        }

        public boolean isViewBlocking(@NotNull BlockGetter level, @NotNull BlockPos pos) {
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.isViewBlocking(level, pos);
            }
            return false;
        }
    }
}

