/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.enums.Tier;
import wootrevived.api.enums.UpgradeDefaultVariant;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.items.basic.BasicItem;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.util.render.WootStyles;

public class ShardDrop
extends WootUpgradeItem<UpgradeDefaultVariant> {
    private static final int[] PERCENTAGES = new int[]{50, 30, 15, 5};
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String IRON_SHARD_DROP_TAG = "iron_shard_drop_upgrade";
    public static final DeferredHolder<Item, ShardDrop> IRON_SHARD_DROP_ITEM = ITEMS.register("iron_shard_drop_upgrade", () -> new ShardDrop(UpgradeDefaultVariant.IRON));
    public static final String GOLD_SHARD_DROP_TAG = "gold_shard_drop_upgrade";
    public static final DeferredHolder<Item, ShardDrop> GOLD_SHARD_DROP_ITEM = ITEMS.register("gold_shard_drop_upgrade", () -> new ShardDrop(UpgradeDefaultVariant.GOLD));
    public static final String DIAMOND_SHARD_DROP_TAG = "diamond_shard_drop_upgrade";
    public static final DeferredHolder<Item, ShardDrop> DIAMOND_SHARD_DROP_ITEM = ITEMS.register("diamond_shard_drop_upgrade", () -> new ShardDrop(UpgradeDefaultVariant.DIAMOND));
    public static final String NETHERITE_SHARD_DROP_TAG = "netherite_shard_drop_upgrade";
    public static final DeferredHolder<Item, ShardDrop> NETHERITE_SHARD_DROP_ITEM = ITEMS.register("netherite_shard_drop_upgrade", () -> new ShardDrop(UpgradeDefaultVariant.NETHERITE));

    public ShardDrop(UpgradeDefaultVariant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void modifyDrops(@NotNull WootDropsProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        int level;
        Tier tier = properties.getFactoryTier();
        List<ItemStack> drops = properties.getItemDrops();
        RandomSource random = properties.getRandom();
        if (!Tier.TIER_1.isFactoryTierValid(tier)) {
            return;
        }
        float rand = random.nextFloat();
        if (rand <= (float)PERCENTAGES[0] / 100.0f) {
            drops.add(((BasicItem)((Object)ItemsRegistry.IRON_SHARD_ITEM.get())).getDefaultInstance());
        }
        if ((level = ((UpgradeDefaultVariant)this.getVariant(dataComponentHolder)).level()) < 3 || !Tier.TIER_2.isFactoryTierValid(tier)) {
            return;
        }
        rand = random.nextFloat();
        if (rand <= (float)PERCENTAGES[1] / 100.0f) {
            drops.add(((BasicItem)((Object)ItemsRegistry.GOLD_SHARD_ITEM.get())).getDefaultInstance());
        }
        if (level < 4 || !Tier.TIER_3.isFactoryTierValid(tier)) {
            return;
        }
        rand = random.nextFloat();
        if (rand <= (float)PERCENTAGES[2] / 100.0f) {
            drops.add(((BasicItem)((Object)ItemsRegistry.DIAMOND_SHARD_ITEM.get())).getDefaultInstance());
        }
        if (level < 5 || !Tier.TIER_4.isFactoryTierValid(tier)) {
            return;
        }
        rand = random.nextFloat();
        if (rand <= (float)PERCENTAGES[3] / 100.0f) {
            drops.add(((BasicItem)((Object)ItemsRegistry.NETHERITE_SHARD_ITEM.get())).getDefaultInstance());
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        int l = ((UpgradeDefaultVariant)this.getVariant((MutableDataComponentHolder)stack)).level();
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.shard_drop.desc.0", (Object[])new Object[]{Component.translatable((String)("misc.woot_revived.tier_" + l))}).setStyle(WootStyles.DESCRIPTION_STYLE));
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.shard_drop.desc.1", (Object[])new Object[]{Component.translatable((String)("misc.woot_revived.tier_" + (l - 1)))}).setStyle(WootStyles.DESCRIPTION_STYLE));
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.shard_drop.desc.2", (Object[])new Object[]{PERCENTAGES[l - 2]}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(IRON_SHARD_DROP_ITEM);
        registration.register(GOLD_SHARD_DROP_ITEM);
        registration.register(DIAMOND_SHARD_DROP_ITEM);
        registration.register(NETHERITE_SHARD_DROP_ITEM);
    }
}

