/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.enums.UpgradeDefaultVariant;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Rate
extends WootUpgradeItem<UpgradeDefaultVariant> {
    private static final int[] PERCENTAGES = new int[]{10, 20, 30, 50, 75};
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_RATE_TAG = "copper_rate_upgrade";
    public static final DeferredHolder<Item, Rate> COPPER_RATE_ITEM = ITEMS.register("copper_rate_upgrade", () -> new Rate(UpgradeDefaultVariant.COPPER));
    public static final String IRON_RATE_TAG = "iron_rate_upgrade";
    public static final DeferredHolder<Item, Rate> IRON_RATE_ITEM = ITEMS.register("iron_rate_upgrade", () -> new Rate(UpgradeDefaultVariant.IRON));
    public static final String GOLD_RATE_TAG = "gold_rate_upgrade";
    public static final DeferredHolder<Item, Rate> GOLD_RATE_ITEM = ITEMS.register("gold_rate_upgrade", () -> new Rate(UpgradeDefaultVariant.GOLD));
    public static final String DIAMOND_RATE_TAG = "diamond_rate_upgrade";
    public static final DeferredHolder<Item, Rate> DIAMOND_RATE_ITEM = ITEMS.register("diamond_rate_upgrade", () -> new Rate(UpgradeDefaultVariant.DIAMOND));
    public static final String NETHERITE_RATE_TAG = "netherite_rate_upgrade";
    public static final DeferredHolder<Item, Rate> NETHERITE_RATE_ITEM = ITEMS.register("netherite_rate_upgrade", () -> new Rate(UpgradeDefaultVariant.NETHERITE));

    public Rate(UpgradeDefaultVariant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void applyGenerationProperties(@NotNull WootGenerationProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        int rate = properties.getSpawnRate();
        float ratio = 1.0f - (float)PERCENTAGES[((UpgradeDefaultVariant)this.getVariant(dataComponentHolder)).level() - 1] / 100.0f;
        properties.setSpawnRate((int)Math.ceil((float)rate * ratio));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.rate.desc.0", (Object[])new Object[]{PERCENTAGES[((UpgradeDefaultVariant)this.getVariant((MutableDataComponentHolder)stack)).level() - 1]}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_RATE_ITEM);
        registration.register(IRON_RATE_ITEM);
        registration.register(GOLD_RATE_ITEM);
        registration.register(DIAMOND_RATE_ITEM);
        registration.register(NETHERITE_RATE_ITEM);
    }
}

