/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.enums.UpgradeDefaultVariant;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Mass
extends WootUpgradeItem<UpgradeDefaultVariant> {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_MASS_TAG = "copper_mass_upgrade";
    public static final DeferredHolder<Item, Mass> COPPER_MASS_ITEM = ITEMS.register("copper_mass_upgrade", () -> new Mass(UpgradeDefaultVariant.COPPER));
    public static final String IRON_MASS_TAG = "iron_mass_upgrade";
    public static final DeferredHolder<Item, Mass> IRON_MASS_ITEM = ITEMS.register("iron_mass_upgrade", () -> new Mass(UpgradeDefaultVariant.IRON));
    public static final String GOLD_MASS_TAG = "gold_mass_upgrade";
    public static final DeferredHolder<Item, Mass> GOLD_MASS_ITEM = ITEMS.register("gold_mass_upgrade", () -> new Mass(UpgradeDefaultVariant.GOLD));
    public static final String DIAMOND_MASS_TAG = "diamond_mass_upgrade";
    public static final DeferredHolder<Item, Mass> DIAMOND_MASS_ITEM = ITEMS.register("diamond_mass_upgrade", () -> new Mass(UpgradeDefaultVariant.DIAMOND));
    public static final String NETHERITE_MASS_TAG = "netherite_mass_upgrade";
    public static final DeferredHolder<Item, Mass> NETHERITE_MASS_ITEM = ITEMS.register("netherite_mass_upgrade", () -> new Mass(UpgradeDefaultVariant.NETHERITE));

    public Mass(UpgradeDefaultVariant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void applyGenerationProperties(@NotNull WootGenerationProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        properties.setNumberOfSimulations(2 * ((UpgradeDefaultVariant)this.getVariant(dataComponentHolder)).level());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.mass.desc.0", (Object[])new Object[]{2 * ((UpgradeDefaultVariant)this.getVariant((MutableDataComponentHolder)stack)).level()}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_MASS_ITEM);
        registration.register(IRON_MASS_ITEM);
        registration.register(GOLD_MASS_ITEM);
        registration.register(DIAMOND_MASS_ITEM);
        registration.register(NETHERITE_MASS_ITEM);
    }
}

