/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.enums.UpgradeDefaultVariant;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Looting
extends WootUpgradeItem<UpgradeDefaultVariant> {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_LOOTING_TAG = "copper_looting_upgrade";
    public static final DeferredHolder<Item, Looting> COPPER_LOOTING_ITEM = ITEMS.register("copper_looting_upgrade", () -> new Looting(UpgradeDefaultVariant.COPPER));
    public static final String IRON_LOOTING_TAG = "iron_looting_upgrade";
    public static final DeferredHolder<Item, Looting> IRON_LOOTING_ITEM = ITEMS.register("iron_looting_upgrade", () -> new Looting(UpgradeDefaultVariant.IRON));
    public static final String GOLD_LOOTING_TAG = "gold_looting_upgrade";
    public static final DeferredHolder<Item, Looting> GOLD_LOOTING_ITEM = ITEMS.register("gold_looting_upgrade", () -> new Looting(UpgradeDefaultVariant.GOLD));
    public static final String DIAMOND_LOOTING_TAG = "diamond_looting_upgrade";
    public static final DeferredHolder<Item, Looting> DIAMOND_LOOTING_ITEM = ITEMS.register("diamond_looting_upgrade", () -> new Looting(UpgradeDefaultVariant.DIAMOND));
    public static final String NETHERITE_LOOTING_TAG = "netherite_looting_upgrade";
    public static final DeferredHolder<Item, Looting> NETHERITE_LOOTING_ITEM = ITEMS.register("netherite_looting_upgrade", () -> new Looting(UpgradeDefaultVariant.NETHERITE));

    public Looting(UpgradeDefaultVariant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void applySpawnProperties(@NotNull WootSpawnProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        ItemStack itemStack = properties.getMainHandItem();
        if (itemStack.getItem().isEnchantable(itemStack)) {
            HolderLookup.Provider accessor = properties.getLookupProvider();
            HolderLookup.RegistryLookup lookup = accessor.lookupOrThrow(Registries.ENCHANTMENT);
            lookup.get(Enchantments.LOOTING).ifPresent(enchantment -> itemStack.enchant((Holder)enchantment, ((UpgradeDefaultVariant)this.getVariant(dataComponentHolder)).level()));
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.looting.desc.0", (Object[])new Object[]{((UpgradeDefaultVariant)this.getVariant((MutableDataComponentHolder)stack)).level()}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_LOOTING_ITEM);
        registration.register(IRON_LOOTING_ITEM);
        registration.register(GOLD_LOOTING_ITEM);
        registration.register(DIAMOND_LOOTING_ITEM);
        registration.register(NETHERITE_LOOTING_ITEM);
    }
}

