/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.enums.UpgradeDefaultVariant;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Efficiency
extends WootUpgradeItem<UpgradeDefaultVariant> {
    private static final float[] PERCENTAGES = new float[]{10.0f, 20.0f, 30.0f, 40.0f, 50.0f};
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_EFFICIENCY_TAG = "copper_efficiency_upgrade";
    public static final DeferredHolder<Item, Efficiency> COPPER_EFFICIENCY_ITEM = ITEMS.register("copper_efficiency_upgrade", () -> new Efficiency(UpgradeDefaultVariant.COPPER));
    public static final String IRON_EFFICIENCY_TAG = "iron_efficiency_upgrade";
    public static final DeferredHolder<Item, Efficiency> IRON_EFFICIENCY_ITEM = ITEMS.register("iron_efficiency_upgrade", () -> new Efficiency(UpgradeDefaultVariant.IRON));
    public static final String GOLD_EFFICIENCY_TAG = "gold_efficiency_upgrade";
    public static final DeferredHolder<Item, Efficiency> GOLD_EFFICIENCY_ITEM = ITEMS.register("gold_efficiency_upgrade", () -> new Efficiency(UpgradeDefaultVariant.GOLD));
    public static final String DIAMOND_EFFICIENCY_TAG = "diamond_efficiency_upgrade";
    public static final DeferredHolder<Item, Efficiency> DIAMOND_EFFICIENCY_ITEM = ITEMS.register("diamond_efficiency_upgrade", () -> new Efficiency(UpgradeDefaultVariant.DIAMOND));
    public static final String NETHERITE_EFFICIENCY_TAG = "netherite_efficiency_upgrade";
    public static final DeferredHolder<Item, Efficiency> NETHERITE_EFFICIENCY_ITEM = ITEMS.register("netherite_efficiency_upgrade", () -> new Efficiency(UpgradeDefaultVariant.NETHERITE));

    public Efficiency(UpgradeDefaultVariant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void applyGenerationProperties(@NotNull WootGenerationProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        int cost = properties.getVitalityFuelCost();
        float ratio = 1.0f - PERCENTAGES[((UpgradeDefaultVariant)this.getVariant(dataComponentHolder)).level() - 1] / 100.0f;
        properties.setVitalityFuelCost((int)Math.ceil((float)cost * ratio));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.efficiency.desc.0", (Object[])new Object[]{Float.valueOf(PERCENTAGES[((UpgradeDefaultVariant)this.getVariant((MutableDataComponentHolder)stack)).level() - 1])}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_EFFICIENCY_ITEM);
        registration.register(IRON_EFFICIENCY_ITEM);
        registration.register(GOLD_EFFICIENCY_ITEM);
        registration.register(DIAMOND_EFFICIENCY_ITEM);
        registration.register(NETHERITE_EFFICIENCY_ITEM);
    }
}

