/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.api.interfaces.WootUpgradeEnum;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Dimension
extends WootUpgradeItem<Variant> {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String NETHER_DIMENSION_TAG = "nether_dimension_upgrade";
    public static final DeferredHolder<Item, Dimension> NETHER_DIMENSION_ITEM = ITEMS.register("nether_dimension_upgrade", () -> new Dimension(Variant.NETHER));
    public static final String END_DIMENSION_TAG = "end_dimension_upgrade";
    public static final DeferredHolder<Item, Dimension> END_DIMENSION_ITEM = ITEMS.register("end_dimension_upgrade", () -> new Dimension(Variant.END));

    public Dimension(Variant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void applySpawnProperties(@NotNull WootSpawnProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        properties.setDimension(((Variant)this.getVariant(dataComponentHolder)).dimension());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.getVariant((MutableDataComponentHolder)stack) == Variant.NETHER) {
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.dimension.desc.nether").setStyle(WootStyles.DESCRIPTION_STYLE));
        } else {
            tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.dimension.desc.end").setStyle(WootStyles.DESCRIPTION_STYLE));
        }
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(NETHER_DIMENSION_ITEM);
        registration.register(END_DIMENSION_ITEM);
    }

    public static enum Variant implements WootUpgradeEnum<Variant>
    {
        NETHER("nether", (ResourceKey<Level>)Level.NETHER),
        END("end", (ResourceKey<Level>)Level.END);

        private static final Codec<Variant> CODEC;
        private final String name;
        private final ResourceKey<Level> dimension;

        private Variant(String name, ResourceKey<Level> dimension) {
            this.name = name;
            this.dimension = dimension;
        }

        public ResourceKey<Level> dimension() {
            return this.dimension;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @Override
        public Codec<Variant> codec() {
            return CODEC;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

