/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.enums.UpgradeDefaultVariant;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Decapitate
extends WootUpgradeItem<UpgradeDefaultVariant> {
    Ingredient vanillaHeads = Ingredient.of((ItemLike[])new ItemLike[]{Items.ZOMBIE_HEAD, Items.CREEPER_HEAD, Items.PIGLIN_HEAD, Items.DRAGON_HEAD, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL});
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_DECAPITATE_TAG = "copper_decapitate_upgrade";
    public static final DeferredHolder<Item, Decapitate> COPPER_DECAPITATE_ITEM = ITEMS.register("copper_decapitate_upgrade", () -> new Decapitate(UpgradeDefaultVariant.COPPER));
    public static final String IRON_DECAPITATE_TAG = "iron_decapitate_upgrade";
    public static final DeferredHolder<Item, Decapitate> IRON_DECAPITATE_ITEM = ITEMS.register("iron_decapitate_upgrade", () -> new Decapitate(UpgradeDefaultVariant.IRON));
    public static final String GOLD_DECAPITATE_TAG = "gold_decapitate_upgrade";
    public static final DeferredHolder<Item, Decapitate> GOLD_DECAPITATE_ITEM = ITEMS.register("gold_decapitate_upgrade", () -> new Decapitate(UpgradeDefaultVariant.GOLD));
    public static final String DIAMOND_DECAPITATE_TAG = "diamond_decapitate_upgrade";
    public static final DeferredHolder<Item, Decapitate> DIAMOND_DECAPITATE_ITEM = ITEMS.register("diamond_decapitate_upgrade", () -> new Decapitate(UpgradeDefaultVariant.DIAMOND));
    public static final String NETHERITE_DECAPITATE_TAG = "netherite_decapitate_upgrade";
    public static final DeferredHolder<Item, Decapitate> NETHERITE_DECAPITATE_ITEM = ITEMS.register("netherite_decapitate_upgrade", () -> new Decapitate(UpgradeDefaultVariant.NETHERITE));

    public Decapitate(UpgradeDefaultVariant variant) {
        super(new Item.Properties(), variant);
    }

    @Override
    public void applySpawnProperties(@NotNull WootSpawnProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        properties.setDoSimulateChargedCreeper(true);
    }

    @Override
    public void modifyDrops(@NotNull WootDropsProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        List<ItemStack> drops = properties.getItemDrops();
        for (ItemStack drop : drops) {
            if (!this.vanillaHeads.test(drop)) continue;
            drop.grow(((UpgradeDefaultVariant)this.getVariant(dataComponentHolder)).level() - 1);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.decapitate.desc.0", (Object[])new Object[]{((UpgradeDefaultVariant)this.getVariant((MutableDataComponentHolder)stack)).level()}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_DECAPITATE_ITEM);
        registration.register(IRON_DECAPITATE_ITEM);
        registration.register(GOLD_DECAPITATE_ITEM);
        registration.register(DIAMOND_DECAPITATE_ITEM);
        registration.register(NETHERITE_DECAPITATE_ITEM);
    }
}

