/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.internal.WootUpgradeComponent;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.init.Registry;
import wootrevived.woot.init.WootPlugins;
import wootrevived.woot.items.basic.BasicItem;

public class UpgradeItemsRegistry
extends WootUpgradeItemRegistration {
    private final IEventBus wootBus;
    private static final Map<String, Entry<?>> REGISTRY = new HashMap();
    private static final Map<String, Entry<?>> ENTRIES = new HashMap();
    private static final Map<String, DynamicEntry<?>> DYNAMIC_ENTRIES = new HashMap();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    private static final List<ItemStack> DYNAMIC_CREATIVE_ITEMS = new ArrayList<ItemStack>();
    public static final String UPGRADE_BASE_TAG = "upgrade_base";
    public static final DeferredHolder<Item, BasicItem> UPGRADE_BASE_ITEM = ITEMS.register("upgrade_base", () -> new BasicItem(BasicItem.Type.UPGRADE_BASE));

    private UpgradeItemsRegistry(IEventBus wootBus) {
        this.wootBus = wootBus;
    }

    @Override
    public <T extends Enum<T>> void register(DeferredHolder<Item, ? extends WootUpgradeItem<T>> item) {
        this.register(item, null);
    }

    @Override
    public <T extends Enum<T>> void register(DeferredHolder<Item, ? extends WootUpgradeItem<T>> item, Class<T> dynamicVariant) {
        String name = UpgradeItemsRegistry.getNameFromItem(item);
        if (dynamicVariant != null && ENTRIES.containsKey(name)) {
            throw new IllegalStateException("You can't register a dynamic variant item on a same single variant item");
        }
        if (dynamicVariant == null && DYNAMIC_ENTRIES.containsKey(name)) {
            throw new IllegalStateException("You can't register a single variant item on a same dynamic variant item");
        }
        REGISTRY.put(UpgradeItemsRegistry.getNameFromItem(item), new Entry(item));
        if (dynamicVariant != null) {
            DYNAMIC_ENTRIES.put(UpgradeItemsRegistry.getNameFromItem(item), new DynamicEntry<T>(item, dynamicVariant));
        } else {
            ENTRIES.put(UpgradeItemsRegistry.getNameFromItem(item), new Entry(item));
            Registry.addToCreativeTab(item);
        }
    }

    @Override
    public IEventBus getWootEventBus() {
        return this.wootBus;
    }

    public static <T extends Enum<T>> DeferredHolder<Item, ? extends WootUpgradeItem<T>> get(String name) {
        return REGISTRY.get(name).item();
    }

    public static boolean has(String name) {
        return REGISTRY.containsKey(name);
    }

    public static boolean isDynamic(String name) {
        return DYNAMIC_ENTRIES.containsKey(name);
    }

    public static Collection<Entry<?>> getEntries() {
        return ENTRIES.values();
    }

    public static Collection<DynamicEntry<?>> getDynamicEntries() {
        return DYNAMIC_ENTRIES.values();
    }

    public static String getNameFromItem(DeferredHolder<Item, ? extends WootUpgradeItem<?>> item) {
        return item.getId().toString().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static String getNameFromItem(WootUpgradeItem<?> item) {
        return BuiltInRegistries.ITEM.getKey(item).toString().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        Registry.addToCreativeTab(UPGRADE_BASE_ITEM);
        WootPlugins.registerUpgradeItems(new UpgradeItemsRegistry(bus));
    }

    public static void displayDynamicCreativeItems(CreativeModeTab.Output output) {
        if (DYNAMIC_CREATIVE_ITEMS.isEmpty()) {
            for (DynamicEntry<?> entry : DYNAMIC_ENTRIES.values()) {
                UpgradeItemsRegistry.addDynamicCreativeItems(entry);
            }
        }
        DYNAMIC_CREATIVE_ITEMS.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }

    public static <T extends Enum<T>> void addDynamicCreativeItems(DynamicEntry<T> entry) {
        for (Enum constant : (Enum[])entry.variantClass().getEnumConstants()) {
            ItemStack stack = ((WootUpgradeItem)((Object)entry.item.get())).getDefaultInstance();
            stack.set(WootUpgradeComponent.type(), (Object)WootUpgradeComponent.of(constant));
            DYNAMIC_CREATIVE_ITEMS.add(stack);
        }
    }

    public record Entry<T extends Enum<T>>(DeferredHolder<Item, ? extends WootUpgradeItem<T>> item) {
    }

    public record DynamicEntry<T extends Enum<T>>(DeferredHolder<Item, ? extends WootUpgradeItem<T>> item, Class<T> variantClass) {
    }
}

