/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.registries;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import wootrevived.woot.guide.GuideBookItem;
import wootrevived.woot.init.Registry;
import wootrevived.woot.items.basic.BasicItem;
import wootrevived.woot.items.dye_casing.DyeCasingItem;
import wootrevived.woot.items.dye_plate.DyePlateItem;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.items.mob_shard.MobShardProjectile;
import wootrevived.woot.items.mold.MoldItem;
import wootrevived.woot.items.stygian_hammer.StygianHammerItem;
import wootrevived.woot.items.xp.XpItem;

public class ItemsRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((net.minecraft.core.Registry)BuiltInRegistries.ENTITY_TYPE, (String)"woot_revived");
    public static final String STYGIAN_INGOT_TAG = "stygian_ingot";
    public static final DeferredHolder<Item, BasicItem> STYGIAN_INGOT_ITEM = ITEMS.register("stygian_ingot", () -> new BasicItem(BasicItem.Type.STYGIAN_PLATE));
    public static final String STYGIAN_DUST_TAG = "stygian_dust";
    public static final DeferredHolder<Item, BasicItem> STYGIAN_DUST_ITEM = ITEMS.register("stygian_dust", () -> new BasicItem(BasicItem.Type.STYGIAN_DUST));
    public static final String STYGIAN_PLATE_TAG = "stygian_plate";
    public static final DeferredHolder<Item, BasicItem> STYGIAN_PLATE_ITEM = ITEMS.register("stygian_plate", () -> new BasicItem(BasicItem.Type.STYGIAN_PLATE));
    public static final String STYGIAN_HAMMER_TAG = "stygian_hammer";
    public static final DeferredHolder<Item, StygianHammerItem> STYGIAN_HAMMER_ITEM = ITEMS.register("stygian_hammer", StygianHammerItem::new);
    public static final String PLATE_MOLD_TAG = "plate_mold";
    public static final DeferredHolder<Item, MoldItem> PLATE_MOLD_ITEM = ITEMS.register("plate_mold", () -> new MoldItem(MoldItem.MoldType.PLATE));
    public static final String SHARD_MOLD_TAG = "shard_mold";
    public static final DeferredHolder<Item, MoldItem> SHARD_MOLD_ITEM = ITEMS.register("shard_mold", () -> new MoldItem(MoldItem.MoldType.SHARD));
    public static final String DYE_CASING_MOLD_TAG = "dye_casing_mold";
    public static final DeferredHolder<Item, MoldItem> DYE_CASING_MOLD_ITEM = ITEMS.register("dye_casing_mold", () -> new MoldItem(MoldItem.MoldType.DYE_CASING));
    public static final String PRISM_TAG = "prism";
    public static final DeferredHolder<Item, BasicItem> PRISM_ITEM = ITEMS.register("prism", () -> new BasicItem(BasicItem.Type.PRISM));
    public static final String MOB_SHARD_TAG = "mob_shard";
    public static final DeferredHolder<Item, MobShardItem> MOB_SHARD_ITEM = ITEMS.register("mob_shard", MobShardItem::new);
    public static final DeferredHolder<EntityType<?>, EntityType<MobShardProjectile>> MOB_SHARD_PROJECTILE = ENTITY_TYPES.register("mob_shard", () -> EntityType.Builder.of(MobShardProjectile::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).build(MOB_SHARD_TAG));
    public static final String XP_SHARD_TAG = "xp_shard";
    public static final DeferredHolder<Item, XpItem> XP_SHARD_ITEM = ITEMS.register("xp_shard", () -> new XpItem(XpItem.Variant.SHARD));
    public static final String XP_SPLINTER_TAG = "xp_splinter";
    public static final DeferredHolder<Item, XpItem> XP_SPLINTER_ITEM = ITEMS.register("xp_splinter", () -> new XpItem(XpItem.Variant.SPLINTER));
    public static final String COPPER_SHARD_TAG = "copper_shard";
    public static final DeferredHolder<Item, BasicItem> COPPER_SHARD_ITEM = ITEMS.register("copper_shard", () -> new BasicItem(BasicItem.Type.COPPER_SHARD));
    public static final String IRON_SHARD_TAG = "iron_shard";
    public static final DeferredHolder<Item, BasicItem> IRON_SHARD_ITEM = ITEMS.register("iron_shard", () -> new BasicItem(BasicItem.Type.IRON_SHARD));
    public static final String GOLD_SHARD_TAG = "gold_shard";
    public static final DeferredHolder<Item, BasicItem> GOLD_SHARD_ITEM = ITEMS.register("gold_shard", () -> new BasicItem(BasicItem.Type.GOLD_SHARD));
    public static final String DIAMOND_SHARD_TAG = "diamond_shard";
    public static final DeferredHolder<Item, BasicItem> DIAMOND_SHARD_ITEM = ITEMS.register("diamond_shard", () -> new BasicItem(BasicItem.Type.DIAMOND_SHARD));
    public static final String NETHERITE_SHARD_TAG = "netherite_shard";
    public static final DeferredHolder<Item, BasicItem> NETHERITE_SHARD_ITEM = ITEMS.register("netherite_shard", () -> new BasicItem(BasicItem.Type.NETHERITE_SHARD));
    public static final String COPPER_ENCHANTED_PLATE_TAG = "copper_enchanted_plate";
    public static final DeferredHolder<Item, BasicItem> COPPER_ENCHANTED_PLATE_ITEM = ITEMS.register("copper_enchanted_plate", () -> new BasicItem(BasicItem.Type.COPPER_ENCHANTED_PLATE));
    public static final String IRON_ENCHANTED_PLATE_TAG = "iron_enchanted_plate";
    public static final DeferredHolder<Item, BasicItem> IRON_ENCHANTED_PLATE_ITEM = ITEMS.register("iron_enchanted_plate", () -> new BasicItem(BasicItem.Type.IRON_ENCHANTED_PLATE));
    public static final String GOLD_ENCHANTED_PLATE_TAG = "gold_enchanted_plate";
    public static final DeferredHolder<Item, BasicItem> GOLD_ENCHANTED_PLATE_ITEM = ITEMS.register("gold_enchanted_plate", () -> new BasicItem(BasicItem.Type.GOLD_ENCHANTED_PLATE));
    public static final String DIAMOND_ENCHANTED_PLATE_TAG = "diamond_enchanted_plate";
    public static final DeferredHolder<Item, BasicItem> DIAMOND_ENCHANTED_PLATE_ITEM = ITEMS.register("diamond_enchanted_plate", () -> new BasicItem(BasicItem.Type.DIAMOND_ENCHANTED_PLATE));
    public static final String NETHERITE_ENCHANTED_PLATE_TAG = "netherite_enchanted_plate";
    public static final DeferredHolder<Item, BasicItem> NETHERITE_ENCHANTED_PLATE_ITEM = ITEMS.register("netherite_enchanted_plate", () -> new BasicItem(BasicItem.Type.NETHERITE_ENCHANTED_PLATE));
    public static final DeferredHolder<Item, DyePlateItem> WHITE_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.WHITE);
    public static final DeferredHolder<Item, DyePlateItem> ORANGE_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.ORANGE);
    public static final DeferredHolder<Item, DyePlateItem> MAGENTA_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.MAGENTA);
    public static final DeferredHolder<Item, DyePlateItem> LIGHT_BLUE_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.LIGHT_BLUE);
    public static final DeferredHolder<Item, DyePlateItem> YELLOW_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.YELLOW);
    public static final DeferredHolder<Item, DyePlateItem> LIME_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.LIME);
    public static final DeferredHolder<Item, DyePlateItem> PINK_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.PINK);
    public static final DeferredHolder<Item, DyePlateItem> GRAY_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.GRAY);
    public static final DeferredHolder<Item, DyePlateItem> LIGHT_GRAY_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.LIGHT_GRAY);
    public static final DeferredHolder<Item, DyePlateItem> CYAN_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.CYAN);
    public static final DeferredHolder<Item, DyePlateItem> PURPLE_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.PURPLE);
    public static final DeferredHolder<Item, DyePlateItem> BLUE_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.BLUE);
    public static final DeferredHolder<Item, DyePlateItem> BROWN_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.BROWN);
    public static final DeferredHolder<Item, DyePlateItem> GREEN_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.GREEN);
    public static final DeferredHolder<Item, DyePlateItem> RED_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.RED);
    public static final DeferredHolder<Item, DyePlateItem> BLACK_DYE_PLATE_ITEM = ItemsRegistry.registerDyePlateItem(DyeColor.BLACK);
    public static final DeferredHolder<Item, DyeCasingItem> WHITE_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.WHITE);
    public static final DeferredHolder<Item, DyeCasingItem> ORANGE_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.ORANGE);
    public static final DeferredHolder<Item, DyeCasingItem> MAGENTA_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.MAGENTA);
    public static final DeferredHolder<Item, DyeCasingItem> LIGHT_BLUE_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.LIGHT_BLUE);
    public static final DeferredHolder<Item, DyeCasingItem> YELLOW_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.YELLOW);
    public static final DeferredHolder<Item, DyeCasingItem> LIME_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.LIME);
    public static final DeferredHolder<Item, DyeCasingItem> PINK_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.PINK);
    public static final DeferredHolder<Item, DyeCasingItem> GRAY_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.GRAY);
    public static final DeferredHolder<Item, DyeCasingItem> LIGHT_GRAY_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.LIGHT_GRAY);
    public static final DeferredHolder<Item, DyeCasingItem> CYAN_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.CYAN);
    public static final DeferredHolder<Item, DyeCasingItem> PURPLE_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.PURPLE);
    public static final DeferredHolder<Item, DyeCasingItem> BLUE_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.BLUE);
    public static final DeferredHolder<Item, DyeCasingItem> BROWN_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.BROWN);
    public static final DeferredHolder<Item, DyeCasingItem> GREEN_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.GREEN);
    public static final DeferredHolder<Item, DyeCasingItem> RED_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.RED);
    public static final DeferredHolder<Item, DyeCasingItem> BLACK_DYE_CASING_ITEM = ItemsRegistry.registerDyeCasingItem(DyeColor.BLACK);
    public static final String GUIDE_BOOK_TAG = "guide";
    public static final DeferredHolder<Item, GuideBookItem> GUIDE_BOOK_ITEM = ITEMS.register("guide", GuideBookItem::new);

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        ENTITY_TYPES.register(bus);
        for (DeferredHolder item : ITEMS.getEntries()) {
            Registry.addToCreativeTab((DeferredHolder<? extends ItemLike, ? extends ItemLike>)item);
        }
    }

    private static DeferredHolder<Item, DyePlateItem> registerDyePlateItem(DyeColor color) {
        return ITEMS.register(color.getName() + "_dye_plate", () -> new DyePlateItem(color));
    }

    private static DeferredHolder<Item, DyeCasingItem> registerDyeCasingItem(DyeColor color) {
        return ITEMS.register(color.getName() + "_dye_casing", () -> new DyeCasingItem(color));
    }
}

