/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.item_infuser;

import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.woot.Woot;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;

public class ItemInfuserRecipeBuilder {
    private FluidStack fluid;
    private Ingredient ingredient;
    private Ingredient augment;
    private final ItemStack output;
    private int energy;

    protected ItemInfuserRecipeBuilder(ItemLike output, int count) {
        this.output = output.asItem().getDefaultInstance();
        this.output.setCount(count);
        this.augment = Ingredient.EMPTY;
    }

    public static ItemInfuserRecipeBuilder itemInfuserRecipe(ItemLike output, int count) {
        return new ItemInfuserRecipeBuilder(output, count);
    }

    public static ItemInfuserRecipeBuilder itemInfuserRecipe(ItemLike output) {
        return new ItemInfuserRecipeBuilder(output, 1);
    }

    public ItemInfuserRecipeBuilder fluid(Fluid fluid, int amount) {
        this.fluid = new FluidStack(fluid, amount);
        return this;
    }

    public ItemInfuserRecipeBuilder fluid(Fluid fluid) {
        this.fluid = new FluidStack(fluid, 1000);
        return this;
    }

    public ItemInfuserRecipeBuilder fluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
        return this;
    }

    public ItemInfuserRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public ItemInfuserRecipeBuilder augment(Ingredient augment) {
        this.augment = augment;
        return this;
    }

    public ItemInfuserRecipeBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()).getPath());
    }

    public void save(RecipeOutput recipeOutput, String path) {
        recipeOutput.accept(Woot.location("item_infuser/" + path), (Recipe)new ItemInfuserRecipe(this.energy, this.fluid, this.ingredient, this.augment.isEmpty() ? Optional.empty() : Optional.of(this.augment), this.output), null);
    }
}

