/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.item_infuser;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootRecipeInput;

public class ItemInfuserRecipe
implements Recipe<WootRecipeInput> {
    public static final MapCodec<ItemInfuserRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("energy").forGetter(ItemInfuserRecipe::getEnergy), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(ItemInfuserRecipe::getFluid), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(ItemInfuserRecipe::getIngredient), (App)Ingredient.CODEC.optionalFieldOf("augment").forGetter(ItemInfuserRecipe::getAugment), (App)ItemStack.CODEC.fieldOf("output").forGetter(ItemInfuserRecipe::getOutput)).apply((Applicative)inst, ItemInfuserRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemInfuserRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ItemInfuserRecipe::getEnergy, (StreamCodec)FluidStack.STREAM_CODEC, ItemInfuserRecipe::getFluid, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemInfuserRecipe::getIngredient, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), ItemInfuserRecipe::getAugment, (StreamCodec)ItemStack.STREAM_CODEC, ItemInfuserRecipe::getOutput, ItemInfuserRecipe::new);
    private final int energy;
    private final FluidStack fluid;
    private final Ingredient ingredient;
    private final Optional<Ingredient> augment;
    private final ItemStack output;

    public ItemInfuserRecipe(int energy, @NotNull FluidStack fluid, @NotNull Ingredient ingredient, @NotNull Optional<Ingredient> augment, @NotNull ItemStack output) {
        this.energy = energy;
        this.fluid = fluid;
        this.ingredient = ingredient;
        this.augment = augment;
        this.output = output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.ITEM_INFUSER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.ITEM_INFUSER_RECIPE_TYPE.get();
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluid.copy();
    }

    @NotNull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public Optional<Ingredient> getAugment() {
        return this.augment;
    }

    @NotNull
    public ItemStack getOutput() {
        return this.output.copy();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int ingredientCount(Item item) {
        for (ItemStack stack : this.ingredient.getItems()) {
            if (!stack.is(item)) continue;
            return stack.getCount();
        }
        return 0;
    }

    public int augmentCount(Item item) {
        if (this.augment.isEmpty()) {
            return 0;
        }
        for (ItemStack stack : this.augment.get().getItems()) {
            if (!stack.is(item)) continue;
            return stack.getCount();
        }
        return 0;
    }

    public boolean matches(@NotNull WootRecipeInput input, @NotNull Level level) {
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.getFluid(), (FluidStack)input.getFluid(0))) {
            return false;
        }
        if (!this.getIngredient().test(input.getItem(1))) {
            return false;
        }
        return this.getAugment().isEmpty() || this.getAugment().get().test(input.getItem(2));
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor((RecipeType)RecipesRegistry.ITEM_INFUSER_RECIPE_TYPE.get())) {
            Validator.add(((ItemInfuserRecipe)recipeHolder.value()).ingredient, ((ItemInfuserRecipe)recipeHolder.value()).augment, ((ItemInfuserRecipe)recipeHolder.value()).fluid);
        }
    }

    @NotNull
    public ItemStack assemble(WootRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Validator {
        private static final List<Ingredient> validIngredients = new ArrayList<Ingredient>();
        private static final List<Ingredient> validAugments = new ArrayList<Ingredient>();
        private static final List<FluidStack> validFluids = new ArrayList<FluidStack>();

        public static boolean isIngredientValid(ItemStack item) {
            for (Ingredient ingredient : validIngredients) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        public static boolean isAugmentValid(ItemStack item) {
            for (Ingredient ingredient : validAugments) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        public static boolean isFluidValid(FluidStack fluid) {
            for (FluidStack fluidStack : validFluids) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)fluid)) continue;
                return true;
            }
            return false;
        }

        protected static void add(Ingredient ingredient, Optional<Ingredient> augment, FluidStack fluid) {
            validIngredients.add(ingredient);
            augment.ifPresent(validAugments::add);
            validFluids.add(fluid);
        }

        protected static void clear() {
            validIngredients.clear();
            validAugments.clear();
            validFluids.clear();
        }
    }
}

