/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.fluid_infuser;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.woot.Woot;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;

public class FluidInfuserRecipeBuilder {
    private FluidStack inputFluid;
    private Ingredient ingredient;
    private final FluidStack outputFluid;
    private int energy;

    protected FluidInfuserRecipeBuilder(FluidStack outputFluid) {
        this.outputFluid = outputFluid;
    }

    public static FluidInfuserRecipeBuilder fluidInfuserRecipe(Fluid outputFluid, int amount) {
        return new FluidInfuserRecipeBuilder(new FluidStack(outputFluid, amount));
    }

    public static FluidInfuserRecipeBuilder fluidInfuserRecipe(Fluid outputFluid) {
        return new FluidInfuserRecipeBuilder(new FluidStack(outputFluid, 1000));
    }

    public static FluidInfuserRecipeBuilder fluidInfuserRecipe(FluidStack outputFluid) {
        return new FluidInfuserRecipeBuilder(outputFluid);
    }

    public FluidInfuserRecipeBuilder fluid(Fluid fluid, int amount) {
        this.inputFluid = new FluidStack(fluid, amount);
        return this;
    }

    public FluidInfuserRecipeBuilder fluid(Fluid fluid) {
        this.inputFluid = new FluidStack(fluid, 1000);
        return this;
    }

    public FluidInfuserRecipeBuilder fluid(FluidStack fluidStack) {
        this.inputFluid = fluidStack;
        return this;
    }

    public FluidInfuserRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public FluidInfuserRecipeBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public void save(RecipeOutput recipeOutput, String path) {
        recipeOutput.accept(Woot.location("fluid_infuser/" + path), (Recipe)new FluidInfuserRecipe(this.energy, this.inputFluid, this.ingredient, this.outputFluid), null);
    }
}

