/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.enchanted_liquifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootRecipeInput;

public class EnchantedLiquifierRecipe
implements Recipe<WootRecipeInput> {
    private final int energy;
    private final Ingredient ingredient;
    private final FluidStack output;
    public static List<Enchantment> enchantments = new ArrayList<Enchantment>();

    public EnchantedLiquifierRecipe(int energy, Ingredient ingredient, FluidStack output) {
        this.energy = energy;
        this.ingredient = ingredient;
        this.output = output;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getEnergy() {
        return this.energy;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        throw new IllegalStateException("Enchanted Serializer shouldn't exist");
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.ENCHANTED_LIQUIFIER_RECIPE_TYPE.get();
    }

    public boolean matches(@NotNull WootRecipeInput input, @NotNull Level level) {
        return false;
    }

    public static void loadRecipes(@NotNull Level level) {
        RegistryAccess accessor = level.registryAccess();
        HolderLookup.RegistryLookup lookup = accessor.lookupOrThrow(Registries.ENCHANTMENT);
        enchantments.clear();
        lookup.listElements().forEach(enchantment -> enchantments.add((Enchantment)enchantment.value()));
    }

    @NotNull
    public ItemStack assemble(WootRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }
}

