/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.dye_liquifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.common.WootCodecs;
import wootrevived.woot.util.recipes.WootRecipeInput;

public class DyeLiquifierRecipe
implements Recipe<WootRecipeInput> {
    public static final MapCodec<DyeLiquifierRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("energy").forGetter(DyeLiquifierRecipe::getEnergy), (App)WootCodecs.NON_NEGATIVE_FLOAT.fieldOf("red_multiplier").forGetter(DyeLiquifierRecipe::getInternalRed), (App)WootCodecs.NON_NEGATIVE_FLOAT.fieldOf("yellow_multiplier").forGetter(DyeLiquifierRecipe::getInternalYellow), (App)WootCodecs.NON_NEGATIVE_FLOAT.fieldOf("blue_multiplier").forGetter(DyeLiquifierRecipe::getInternalBlue), (App)WootCodecs.NON_NEGATIVE_FLOAT.fieldOf("white_multiplier").forGetter(DyeLiquifierRecipe::getInternalWhite), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(DyeLiquifierRecipe::getIngredient)).apply((Applicative)inst, DyeLiquifierRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DyeLiquifierRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DyeLiquifierRecipe::getEnergy, (StreamCodec)ByteBufCodecs.FLOAT, DyeLiquifierRecipe::getInternalRed, (StreamCodec)ByteBufCodecs.FLOAT, DyeLiquifierRecipe::getInternalYellow, (StreamCodec)ByteBufCodecs.FLOAT, DyeLiquifierRecipe::getInternalBlue, (StreamCodec)ByteBufCodecs.FLOAT, DyeLiquifierRecipe::getInternalWhite, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DyeLiquifierRecipe::getIngredient, DyeLiquifierRecipe::new);
    private final Ingredient ingredient;
    private final int energy;
    private final float red;
    private final float yellow;
    private final float blue;
    private final float white;
    public static float maxMultiplier = 0.0f;

    public DyeLiquifierRecipe(int energy, float red, float yellow, float blue, float white, @NotNull Ingredient ingredient) {
        this.ingredient = ingredient;
        this.energy = energy;
        this.red = red;
        this.yellow = yellow;
        this.blue = blue;
        this.white = white;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.DYE_LIQUIFIER_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getRed() {
        return Math.round(this.red * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public int getYellow() {
        return Math.round(this.yellow * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public int getBlue() {
        return Math.round(this.blue * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public int getWhite() {
        return Math.round(this.white * (float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue());
    }

    public float getInternalRed() {
        return this.red;
    }

    public float getInternalYellow() {
        return this.yellow;
    }

    public float getInternalBlue() {
        return this.blue;
    }

    public float getInternalWhite() {
        return this.white;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int ingredientCount(Item item) {
        for (ItemStack stack : this.ingredient.getItems()) {
            if (!stack.is(item)) continue;
            return stack.getCount();
        }
        return 0;
    }

    public boolean matches(WootRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        maxMultiplier = 0.0f;
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get())) {
            DyeLiquifierRecipe dyeLiquifierRecipe = (DyeLiquifierRecipe)recipeHolder.value();
            Validator.add(dyeLiquifierRecipe.getIngredient(), dyeLiquifierRecipe);
            if (maxMultiplier < dyeLiquifierRecipe.getInternalRed()) {
                maxMultiplier = dyeLiquifierRecipe.getInternalRed();
            }
            if (maxMultiplier < dyeLiquifierRecipe.getInternalYellow()) {
                maxMultiplier = dyeLiquifierRecipe.getInternalYellow();
            }
            if (maxMultiplier < dyeLiquifierRecipe.getInternalBlue()) {
                maxMultiplier = dyeLiquifierRecipe.getInternalBlue();
            }
            if (!(maxMultiplier < dyeLiquifierRecipe.getInternalWhite())) continue;
            maxMultiplier = dyeLiquifierRecipe.getInternalWhite();
        }
    }

    @NotNull
    public ItemStack assemble(WootRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Validator {
        private static final List<Pair<Ingredient, DyeLiquifierRecipe>> validIngredients = new ArrayList<Pair<Ingredient, DyeLiquifierRecipe>>();

        public static boolean isIngredientValid(ItemStack item, Colors colors) {
            for (Pair<Ingredient, DyeLiquifierRecipe> ingredient : validIngredients) {
                if (!((Ingredient)ingredient.getFirst()).test(item)) continue;
                if (colors == Colors.ANY) {
                    return true;
                }
                DyeLiquifierRecipe recipe = (DyeLiquifierRecipe)ingredient.getSecond();
                return colors == Colors.RED && recipe.getInternalRed() > 0.0f || colors == Colors.YELLOW && recipe.getInternalYellow() > 0.0f || colors == Colors.BLUE && recipe.getInternalBlue() > 0.0f || colors == Colors.WHITE && recipe.getInternalWhite() > 0.0f;
            }
            return false;
        }

        protected static void add(Ingredient ingredient, DyeLiquifierRecipe recipe) {
            validIngredients.add((Pair<Ingredient, DyeLiquifierRecipe>)Pair.of((Object)ingredient, (Object)recipe));
        }

        protected static void clear() {
            validIngredients.clear();
        }
    }

    public static enum Colors {
        RED,
        YELLOW,
        BLUE,
        WHITE,
        ANY;

    }
}

