/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.network;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import wootrevived.woot.Woot;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.common.WootCodecs;
import wootrevived.woot.util.entity.WootMachineBlockEntity;

public record WootMachineUpdate(BlockPos blockPos, RedstoneMode redstoneMode, List<EnumMap<MachineSide, MachineSideProperty>> listMachineProperties) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Woot.location("woot_machine_update");
    public static final CustomPacketPayload.Type<WootMachineUpdate> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, WootMachineUpdate> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WootMachineUpdate::blockPos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(RedstoneMode.class), WootMachineUpdate::redstoneMode, WootCodecs.MACHINE_PROPERTIES_STREAM_CODEC, WootMachineUpdate::listMachineProperties, WootMachineUpdate::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(WootMachineUpdate pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            WootMachineBlockEntity wootMachineBlockEntity;
            Player sender = ctx.player();
            if (!(sender instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)sender;
            if (!player.level().isLoaded(pkt.blockPos)) {
                return;
            }
            BlockEntity blockEntity = player.level().getBlockEntity(pkt.blockPos);
            if (blockEntity instanceof WootMachineBlockEntity && (wootMachineBlockEntity = (WootMachineBlockEntity)blockEntity).canPlayerAccess(player)) {
                wootMachineBlockEntity.handleNewState(pkt);
            }
        });
    }
}

