/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import wootrevived.woot.Woot;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.util.common.RedstoneMode;

public record WootFakeSpawnerUpdate(BlockPos blockPos, RedstoneMode redstoneMode) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Woot.location("woot_fake_spawner_update");
    public static final CustomPacketPayload.Type<WootFakeSpawnerUpdate> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, WootFakeSpawnerUpdate> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WootFakeSpawnerUpdate::blockPos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(RedstoneMode.class), WootFakeSpawnerUpdate::redstoneMode, WootFakeSpawnerUpdate::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(WootFakeSpawnerUpdate pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            FakeSpawnerBlockEntity fakeSpawnerBlockEntity;
            Player sender = ctx.player();
            if (!(sender instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)sender;
            if (!player.level().isLoaded(pkt.blockPos)) {
                return;
            }
            BlockEntity blockEntity = sender.level().getBlockEntity(pkt.blockPos);
            if (blockEntity instanceof FakeSpawnerBlockEntity && (fakeSpawnerBlockEntity = (FakeSpawnerBlockEntity)blockEntity).canPlayerAccess(player)) {
                fakeSpawnerBlockEntity.handleNewState(pkt);
            }
        });
    }
}

