/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.multiblock;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.enums.Tier;
import wootrevived.woot.data.MultiBlockFactoryData;
import wootrevived.woot.multiblock.MultiBlockFactory;

public abstract class MultiBlockFactoryEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    protected Tier tier = Tier.INVALID;

    public MultiBlockFactoryEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof MultiBlockFactoryEntity) {
            MultiBlockFactoryEntity multiBlockFactoryEntity = (MultiBlockFactoryEntity)blockEntity;
            multiBlockFactoryEntity.tick(level, pos, state, blockEntity);
        }
    }

    public void updatePattern(Level level) {
        BlockState state = this.getBlockState();
        if (!state.hasProperty((Property)BlockStateProperties.ENABLED) || !((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        Direction facing = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : Direction.NORTH;
        Tier newTier = MultiBlockFactory.updatePattern(level, this.getBlockPos(), facing);
        if (newTier != this.tier) {
            this.tier = newTier;
            this.setChanged();
        }
    }

    public Tier getFactoryTier() {
        return this.tier;
    }

    private MultiBlockFactoryData.Component getComponent() {
        return new MultiBlockFactoryData.Component(this.tier);
    }

    private void setComponent(MultiBlockFactoryData.Component component) {
        this.tier = component.tier();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        MultiBlockFactoryData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        MultiBlockFactoryData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

