/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.items.xp;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.util.render.WootStyles;

public class XpItem
extends Item {
    private static final int STACK_SIZE = 64;
    public static final int SPLINTERS_IN_STACK = 9;
    private static final int SHARD_XP = 9;
    private static final int SPLINTER_XP = 1;
    final Variant variant;

    public XpItem(Variant variant) {
        super(new Item.Properties().stacksTo(64));
        this.variant = variant;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public static ItemStack getItemStack(Variant variant) {
        if (variant == Variant.SHARD) {
            return ((XpItem)((Object)ItemsRegistry.XP_SHARD_ITEM.get())).getDefaultInstance();
        }
        return ((XpItem)((Object)ItemsRegistry.XP_SPLINTER_ITEM.get())).getDefaultInstance();
    }

    public static List<ItemStack> getShards(int xp) {
        ArrayList<ItemStack> shards = new ArrayList<ItemStack>();
        int xpShards = xp / 9;
        int xpSplinters = xp % 9;
        int fullStacks = xpShards / 64;
        int leftoverShard = xpShards % 64;
        for (int i = 0; i < fullStacks; ++i) {
            ItemStack itemStack = XpItem.getItemStack(Variant.SHARD);
            itemStack.setCount(64);
            shards.add(itemStack);
        }
        if (leftoverShard > 0) {
            ItemStack itemStack = XpItem.getItemStack(Variant.SHARD);
            itemStack.setCount(leftoverShard);
            shards.add(itemStack);
        }
        if (xpSplinters > 0) {
            ItemStack itemStack = XpItem.getItemStack(Variant.SPLINTER);
            itemStack.setCount(xpSplinters);
            shards.add(itemStack);
        }
        return shards;
    }

    private int getXp(ItemStack itemStack) {
        if (itemStack.getItem() == ItemsRegistry.XP_SHARD_ITEM.get()) {
            return 9;
        }
        if (itemStack.getItem() == ItemsRegistry.XP_SPLINTER_ITEM.get()) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (level.isClientSide()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (itemStack.isEmpty()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        ItemStack advancementStack = itemStack.copy();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.2f, 0.5f * ((level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.7f + 1.8f));
        if (player instanceof FakePlayer) {
            level.addFreshEntity((Entity)new ExperienceOrb(level, player.getX(), player.getY(), player.getZ(), 1));
            itemStack.shrink(1);
        } else {
            int xp = 0;
            if (player.isShiftKeyDown()) {
                xp = this.getXp(itemStack) * itemStack.getCount();
                if (!player.isCreative()) {
                    itemStack.setCount(0);
                }
            } else {
                xp = this.getXp(itemStack);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
            }
            if (xp > 0) {
                player.takeXpDelay = 0;
                ExperienceOrb orb = new ExperienceOrb(level, 0.0, 0.0, 0.0, xp);
                orb.playerTouch(player);
                player.takeXpDelay = 0;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, advancementStack);
                }
            }
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, ctx, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.shard.0").setStyle(WootStyles.DESCRIPTION_STYLE));
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.shard.1").setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static enum Variant {
        SHARD,
        SPLINTER;

    }
}

