/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import wootrevived.woot.multiblock.MultiBlockFactoryEntity;
import wootrevived.woot.multiblock.patterns.Patterns;

@EventBusSubscriber(modid="woot_revived")
public class MultiBlockUpdate {
    @SubscribeEvent
    public static void onEntityPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor accessor = event.getLevel();
        if (accessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)accessor;
            BlockState state = event.getPlacedBlock();
            if (Patterns.getValidBlocks().contains(state.getBlock())) {
                MultiBlockUpdate.updateMultiblocksPattern(level, List.of(event.getPos()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityBreak(BlockEvent.BreakEvent event) {
        LevelAccessor accessor = event.getLevel();
        if (accessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)accessor;
            BlockState state = event.getState();
            if (Patterns.getValidBlocks().contains(state.getBlock())) {
                level.getServer().execute(() -> MultiBlockUpdate.updateMultiblocksPattern(level, List.of(event.getPos())));
            }
        }
    }

    @SubscribeEvent
    public static void onChunkSent(ChunkWatchEvent.Sent event) {
        ServerLevel level = event.getLevel();
        for (BlockEntity be : event.getChunk().getBlockEntities().values()) {
            if (!(be instanceof MultiBlockFactoryEntity)) continue;
            MultiBlockFactoryEntity entity = (MultiBlockFactoryEntity)be;
            entity.updatePattern((Level)level);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            List<BlockPos> validBlocks = event.getAffectedBlocks().stream().filter(pos -> Patterns.getValidBlocks().contains(level2.getBlockState(pos).getBlock())).toList();
            if (!validBlocks.isEmpty()) {
                level2.getServer().tell((Runnable)new TickTask(level2.getServer().getTickCount() + 1, () -> MultiBlockUpdate.updateMultiblocksPattern(level2, validBlocks)));
            }
        }
    }

    private static void updateMultiblocksPattern(ServerLevel level, List<BlockPos> positions) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (BlockPos pos : positions) {
            AABB area = Patterns.getSearchAABB(pos);
            if (minX > area.minX) {
                minX = area.minX;
            }
            if (minY > area.minY) {
                minY = area.minY;
            }
            if (minZ > area.minZ) {
                minZ = area.minZ;
            }
            if (maxX < area.maxX) {
                maxX = area.maxX;
            }
            if (maxY < area.maxY) {
                maxY = area.maxY;
            }
            if (!(maxZ < area.maxZ)) continue;
            maxZ = area.maxZ;
        }
        int minSectionX = SectionPos.blockToSectionCoord((double)minX);
        int minSectionZ = SectionPos.blockToSectionCoord((double)minZ);
        int maxSectionX = SectionPos.blockToSectionCoord((double)maxX);
        int maxSectionZ = SectionPos.blockToSectionCoord((double)maxZ);
        for (int sectionX = minSectionX; sectionX <= maxSectionX; ++sectionX) {
            for (int sectionZ = minSectionZ; sectionZ <= maxSectionZ; ++sectionZ) {
                LevelChunk chunk = level.getChunk(sectionX, sectionZ);
                for (BlockPos entityPos : chunk.getBlockEntitiesPos()) {
                    BlockEntity entity;
                    if (!(minX <= (double)entityPos.getX()) || !(minY <= (double)entityPos.getY()) || !(minZ <= (double)entityPos.getZ()) || !(maxX >= (double)entityPos.getX()) || !(maxY >= (double)entityPos.getY()) || !(maxZ >= (double)entityPos.getZ()) || !((entity = chunk.getBlockEntity(entityPos)) instanceof MultiBlockFactoryEntity)) continue;
                    MultiBlockFactoryEntity multiblock = (MultiBlockFactoryEntity)entity;
                    multiblock.updatePattern((Level)level);
                }
            }
        }
    }
}

