/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.locale.Language;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.items.mob_shard.MobShardProjectile;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;

@EventBusSubscriber(modid="woot_revived")
public class MobShardKillCheck {
    private static final List<String> uuidList = new ArrayList<String>();

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player killer = (Player)entity;
        if (killer instanceof FakePlayer) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        if (event.getSource().getDirectEntity() != null && event.getEntity().getUUID().equals(event.getSource().getDirectEntity().getUUID())) {
            return;
        }
        LivingEntity victim = event.getEntity();
        if (MobShardKillCheck.ignoreDeathEvent((Entity)event.getEntity())) {
            return;
        }
        if (victim instanceof Player) {
            return;
        }
        EntityType entityType = victim.getType();
        if (!Language.getInstance().has(entityType.getDescriptionId())) {
            return;
        }
        if (!WootFactoryMobsRegistry.hasFactoryMob(entityType)) {
            return;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(entityType);
        if (mob.isBlacklisted()) {
            return;
        }
        victim.addTag(MobShardProjectile.MOB_SHARD_HAS_BEEN_KILLED);
        if (victim.getTags().contains(MobShardProjectile.MOB_SHARD_KILLED_BY_PROJECTILE)) {
            return;
        }
        ItemStack inHandItemStack = killer.getMainHandItem();
        Item item = inHandItemStack.getItem();
        if (item instanceof MobShardItem) {
            MobShardItem mobShardItem = (MobShardItem)item;
            if (!MobShardItem.isProgrammed(inHandItemStack)) {
                mobShardItem.hurtEnemy(inHandItemStack, victim, (LivingEntity)killer);
            }
        }
        MobShardItem.handleKill(killer, SerializeEntityNBTHelper.serialize((Entity)victim));
    }

    private static boolean ignoreDeathEvent(Entity entity) {
        String uuid = entity.getStringUUID();
        if (uuidList.contains(uuid)) {
            return true;
        }
        uuidList.add(uuid);
        int MAX_UUID_CACHE_SIZE = 10;
        if (uuidList.size() > MAX_UUID_CACHE_SIZE) {
            uuidList.remove(0);
        }
        return false;
    }
}

