/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.events;

import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.recipes.enchanted_liquifier.EnchantedLiquifierRecipe;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.recipes.stygian_anvil.StygianAnvilRecipe;

@EventBusSubscriber(modid="woot_revived")
public class LoadRecipes {
    private static MinecraftServer server;

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        server = event.getServer();
        LoadRecipes.loadRecipes(server.getRecipeManager(), (Level)server.overworld());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        LoadRecipes.loadRecipes(server.getRecipeManager(), (Level)server.overworld());
    }

    private static void loadRecipes(RecipeManager recipeManager, Level level) {
        StygianAnvilRecipe.loadRecipes(recipeManager);
        DyeLiquifierRecipe.loadRecipes(recipeManager);
        FluidInfuserRecipe.loadRecipes(recipeManager);
        ItemInfuserRecipe.loadRecipes(recipeManager);
        EnchantedLiquifierRecipe.loadRecipes(level);
    }

    @EventBusSubscriber(modid="woot_revived", value={Dist.CLIENT})
    public static class ClientSide {
        @SubscribeEvent
        public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            Level level = event.getPlayer().level();
            LoadRecipes.loadRecipes(level.getRecipeManager(), (Level)Minecraft.getInstance().level);
        }

        @SubscribeEvent
        public static void onRecipesUpdated(RecipesUpdatedEvent event) {
            LoadRecipes.loadRecipes(event.getRecipeManager(), (Level)Minecraft.getInstance().level);
        }
    }
}

