/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.simulator;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.woot.drops.simulator.FakeDragonFight;
import wootrevived.woot.drops.simulator.FakeEntityManager;
import wootrevived.woot.drops.simulator.FakeServerPlayer;
import wootrevived.woot.mixins.accessors.LevelMixinAccessor;
import wootrevived.woot.mixins.accessors.ServerLevelMixinAccessor;
import wootrevived.woot.mixins.impl.CreeperMixin;
import wootrevived.woot.mixins.impl.EndDragonFightMixin;
import wootrevived.woot.mixins.impl.EnderDragonMixin;
import wootrevived.woot.mixins.impl.LivingEntityMixin;
import wootrevived.woot.mixins.impl.PersistentEntitySectionManagerMixin;

public class DropSimulator {
    private static final DropSimulator INSTANCE = new DropSimulator();
    private final GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes("woot_revived".getBytes()), "woot_revived");
    private ServerLevel dimensionLevel = null;
    private ResourceKey<Level> dimension;
    private Holder<DimensionType> dimensionTypeRegistration;
    private FakeServerPlayer fakePlayer = null;
    private FakeEntityManager<Entity> fakeEntityManager = null;
    private Creeper chargedCreeper = null;
    private DamageSource playerSource = null;
    private DamageSource chargedCreeperSource = null;

    public static void simulateDrops(WootDropsProperties properties) {
        INSTANCE.simulate(properties);
    }

    @NotNull
    public static ServerLevel getLevel() {
        return DropSimulator.INSTANCE.dimensionLevel;
    }

    @NotNull
    public static RandomSource getRandom() {
        return DropSimulator.INSTANCE.dimensionLevel.getRandom();
    }

    @NotNull
    public static HolderLookup.Provider getLookupProvider() {
        return DropSimulator.INSTANCE.dimensionLevel.registryAccess();
    }

    @Nullable
    public static LivingEntity loadEntity(WootFactoryMob<?> entity, CompoundTag mobTag) {
        return entity.loadEntity(mobTag, DropSimulator.INSTANCE.dimensionLevel);
    }

    public static void patchDimension(WootDropsProperties properties, boolean restore) {
        ServerLevel dropsLevel;
        ServerLevel level = DropSimulator.INSTANCE.dimensionLevel;
        MinecraftServer server = level.getServer();
        if (!restore && (dropsLevel = server.getLevel(properties.getDimension())) != null) {
            ((LevelMixinAccessor)level).woot$setDimension((ResourceKey<Level>)dropsLevel.dimension(), (Holder<DimensionType>)dropsLevel.dimensionTypeRegistration());
        } else {
            ((LevelMixinAccessor)level).woot$setDimension(DropSimulator.INSTANCE.dimension, DropSimulator.INSTANCE.dimensionTypeRegistration);
        }
    }

    private void simulate(WootDropsProperties properties) {
        LivingEntity livingEntity = properties.getEntity();
        if (livingEntity == null) {
            return;
        }
        ItemStack mainHand = properties.getMainHandItem();
        if (!livingEntity.fireImmune() && properties.isInFire()) {
            livingEntity.setRemainingFireTicks(20);
            livingEntity.setSharedFlagOnFire(true);
        }
        this.fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, mainHand);
        this.fakePlayer.setItemInHand(InteractionHand.OFF_HAND, properties.getOffHandItem());
        this.fakeEntityManager.clearEntityList();
        livingEntity.tickCount = 100;
        livingEntity.setLastHurtByPlayer((Player)this.fakePlayer);
        Holder luckAttributeHolder = Attributes.LUCK;
        RangedAttribute luckAttribute = (RangedAttribute)luckAttributeHolder.value();
        this.fakePlayer.getAttribute(luckAttributeHolder).setBaseValue(Mth.clamp((double)properties.getLuck(), (double)luckAttribute.getMinValue(), (double)luckAttribute.getMaxValue()));
        if (livingEntity instanceof EnderDragon) {
            EnderDragon enderDragon = (EnderDragon)livingEntity;
            this.simulateEnderdragon(enderDragon, properties);
            return;
        }
        livingEntity.captureDrops(new ArrayList());
        LivingEntityMixin mixin = (LivingEntityMixin)livingEntity;
        mixin.woot$dropFromLootTable(this.playerSource, true);
        mixin.woot$dropCustomDeathLoot(this.dimensionLevel, this.playerSource, true);
        mixin.woot$dropEquipment();
        mixin.woot$dropExperience((Entity)this.fakePlayer);
        Collection eventDrops = livingEntity.captureDrops(null);
        CommonHooks.onLivingDrops((LivingEntity)livingEntity, (DamageSource)this.playerSource, (Collection)eventDrops, (boolean)true);
        eventDrops.forEach(e -> this.dimensionLevel.addFreshEntity((Entity)e));
        List<ItemStack> drops = properties.getItemDrops();
        int experience = properties.getExperience();
        for (Entity droppedEntity : this.fakeEntityManager.getEntityList()) {
            if (droppedEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)droppedEntity;
                drops.add(itemEntity.getItem());
                continue;
            }
            if (!(droppedEntity instanceof ExperienceOrb)) continue;
            ExperienceOrb experienceOrb = (ExperienceOrb)droppedEntity;
            experience += experienceOrb.getValue();
        }
        properties.setExperience(experience);
        this.fakeEntityManager.clearEntityList();
        if (properties.doSimulateChargedCreeper()) {
            drops.addAll(this.simulateChargedCreeper(livingEntity));
        }
    }

    @NotNull
    private List<ItemStack> simulateChargedCreeper(@NotNull LivingEntity livingEntity) {
        this.fakeEntityManager.clearEntityList();
        livingEntity.tickCount = 0;
        livingEntity.setLastHurtByPlayer(null);
        ((CreeperMixin)this.chargedCreeper).woot$setDroppedSkulls(0);
        livingEntity.captureDrops(null);
        LivingEntityMixin mixin = (LivingEntityMixin)livingEntity;
        mixin.woot$dropCustomDeathLoot(this.dimensionLevel, this.chargedCreeperSource, false);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Entity droppedEntity : this.fakeEntityManager.getEntityList()) {
            if (!(droppedEntity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)droppedEntity;
            drops.add(itemEntity.getItem());
        }
        this.fakeEntityManager.clearEntityList();
        return drops;
    }

    private void simulateEnderdragon(@NotNull EnderDragon enderDragon, WootDropsProperties properties) {
        this.fakeEntityManager.clearEntityList();
        EndDragonFight.Data data = new EndDragonFight.Data(false, false, properties.isEnderDragonAlreadyKilled(), false, Optional.empty(), Optional.empty(), Optional.empty());
        enderDragon.setDragonFight((EndDragonFight)new FakeDragonFight(this.dimensionLevel, this.dimensionLevel.getSeed(), data));
        enderDragon.setSilent(true);
        EnderDragonMixin dragonMixin = (EnderDragonMixin)enderDragon;
        dragonMixin.woot$setUnlimitedLastHurtByPlayer((Player)this.fakePlayer);
        enderDragon.dragonDeathTime = 0;
        while (!((EndDragonFightMixin)enderDragon.getDragonFight()).woot$getDragonKilled()) {
            dragonMixin.woot$tickDeath();
        }
        enderDragon.captureDrops(new ArrayList());
        LivingEntityMixin mixin = (LivingEntityMixin)enderDragon;
        mixin.woot$dropFromLootTable(this.playerSource, true);
        mixin.woot$dropCustomDeathLoot(this.dimensionLevel, this.playerSource, true);
        mixin.woot$dropEquipment();
        mixin.woot$dropExperience((Entity)this.fakePlayer);
        Collection eventDrops = enderDragon.captureDrops(null);
        CommonHooks.onLivingDrops((LivingEntity)enderDragon, (DamageSource)this.playerSource, (Collection)eventDrops, (boolean)true);
        eventDrops.forEach(e -> this.dimensionLevel.addFreshEntity((Entity)e));
        List<ItemStack> drops = properties.getItemDrops();
        int experience = properties.getExperience();
        for (Entity droppedEntity : this.fakeEntityManager.getEntityList()) {
            if (droppedEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)droppedEntity;
                drops.add(itemEntity.getItem());
                continue;
            }
            if (!(droppedEntity instanceof ExperienceOrb)) continue;
            ExperienceOrb experienceOrb = (ExperienceOrb)droppedEntity;
            experience += experienceOrb.getValue();
        }
        properties.setExperience(experience);
        this.fakeEntityManager.clearEntityList();
    }

    public static void init(ServerLevel dimensionLevel) {
        INSTANCE.setup(dimensionLevel);
    }

    private void setup(ServerLevel dimensionLevel) {
        this.setDimensionLevel(dimensionLevel);
        this.patchDimensionLevel();
        this.initFakePlayer();
        this.initDamageSources();
    }

    private void setDimensionLevel(ServerLevel level) {
        this.dimensionLevel = level;
        this.dimension = level.dimension();
        this.dimensionTypeRegistration = level.dimensionTypeRegistration();
    }

    private void initFakePlayer() {
        this.fakePlayer = new FakeServerPlayer(this.dimensionLevel, this.gameProfile);
    }

    private void initDamageSources() {
        DamageSources sources = this.dimensionLevel.damageSources();
        CompoundTag creeper = new CompoundTag();
        creeper.putString("id", "minecraft:creeper");
        creeper.putBoolean("powered", true);
        this.chargedCreeper = (Creeper)EntityType.loadEntityRecursive((CompoundTag)creeper, (Level)this.dimensionLevel, e -> e);
        this.playerSource = sources.playerAttack((Player)this.fakePlayer);
        this.chargedCreeperSource = sources.explosion((Entity)this.chargedCreeper, (Entity)this.chargedCreeper);
    }

    private void patchDimensionLevel() {
        ServerLevelMixinAccessor level = (ServerLevelMixinAccessor)this.dimensionLevel;
        PersistentEntitySectionManager<Entity> persistentEntitySectionManager = level.woot$getEntityManager();
        PersistentEntitySectionManagerMixin entitySectionMixin = (PersistentEntitySectionManagerMixin)persistentEntitySectionManager;
        EntityPersistentStorage entityPersistentStorage = entitySectionMixin.woot$getPermanentStorage();
        this.fakeEntityManager = new FakeEntityManager<Entity>(Entity.class, entitySectionMixin.woot$getCallbacks(), entityPersistentStorage);
        level.woot$setEntityManager(this.fakeEntityManager);
    }
}

