/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;

public class SnifferMob
extends WootFactoryMob<Sniffer> {
    public SnifferMob(EntityType<Sniffer> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public void modifyDrops(WootFactoryMob.Phase phase, WootDropsProperties properties) {
        if (!phase.isBeforeDropCallback()) {
            return;
        }
        ServerLevel level = properties.getLevel();
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.SNIFFER_DIGGING);
        LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)BlockPos.ZERO.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)properties.getEntity()).create(LootContextParamSets.GIFT);
        ObjectArrayList items = lootTable.getRandomItems(lootParams);
        properties.getItemDrops().addAll((Collection<ItemStack>)items);
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new SnifferMob((EntityType<Sniffer>)EntityType.SNIFFER, new WootFactoryMob.Properties()));
    }
}

