/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import com.google.common.base.CaseFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Panda;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.registrations.WootFactoryMobRegistration;

public class PandaMob
extends WootFactoryMob<Panda> {
    public PandaMob(EntityType<Panda> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        MutableComponent tip = Component.empty();
        if (mobTag.getString("MainGene").equals(mobTag.getString("HiddenGene"))) {
            tip.append((Component)Component.literal((String)(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, mobTag.getString("MainGene")).replaceAll("([a-z])([A-Z])", "$1 $2") + " ")));
        } else {
            tip.append((Component)Component.literal((String)"Normal "));
        }
        return tip.append((Component)super.getDisplayName(mobTag, lookupProvider));
    }

    @Override
    public MutableComponent getTooltipKillName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return super.getDisplayName(mobTag, lookupProvider);
    }

    @Override
    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.saveTag(mobTag, lookupProvider);
        tag.putString("MainGene", mobTag.getString("MainGene"));
        tag.putString("HiddenGene", mobTag.getString("HiddenGene"));
        return tag;
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new PandaMob((EntityType<Panda>)EntityType.PANDA, new WootFactoryMob.Properties()));
    }
}

