/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.drops.mobs;

import com.google.common.base.CaseFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.registrations.WootFactoryMobRegistration;

public class FrogMob
extends WootFactoryMob<Frog> {
    public FrogMob(EntityType<Frog> entityType, WootFactoryMob.Properties properties) {
        super(entityType, properties);
    }

    @Override
    public MutableComponent getDisplayName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        FrogVariant variant = (FrogVariant)BuiltInRegistries.FROG_VARIANT.get(ResourceLocation.tryParse((String)mobTag.getString("variant")));
        MutableComponent tip = Component.empty();
        if (variant != null) {
            tip.append((Component)Component.literal((String)(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, ResourceLocation.tryParse((String)mobTag.getString("variant")).getPath()).replaceAll("([a-z])([A-Z])", "$1 $2") + " ")));
        }
        return tip.append((Component)super.getDisplayName(mobTag, lookupProvider));
    }

    @Override
    public MutableComponent getTooltipKillName(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        return super.getDisplayName(mobTag, lookupProvider);
    }

    @Override
    public CompoundTag saveTag(CompoundTag mobTag, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.saveTag(mobTag, lookupProvider);
        tag.putString("variant", mobTag.getString("variant"));
        return tag;
    }

    public static void register(WootFactoryMobRegistration registration) {
        registration.registerFactoryMob(new FrogMob((EntityType<Frog>)EntityType.FROG, new WootFactoryMob.Properties()));
    }
}

