/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.datagen;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;

public class LootTables
extends BlockLootSubProvider {
    public LootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BlocksRegistry.BLOCKS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toList());
    }

    protected void generate() {
        this.dropSelf(BlocksRegistry.STYGIAN_ANVIL_BLOCK);
        this.dropSelf(BlocksRegistry.FACTORY_BASE_BLOCK);
        this.dropSelf(BlocksRegistry.STYGIAN_BLOCK);
        this.copyComponentWithEnable((DeferredHolder<Block, ? extends Block>)BlocksRegistry.FAKE_SPAWNER_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.FAKE_SPAWNER_DATA);
        this.dropSelf(BlocksRegistry.COPPER_MAGMATOR_BLOCK);
        this.dropSelf(BlocksRegistry.IRON_MAGMATOR_BLOCK);
        this.dropSelf(BlocksRegistry.GOLD_MAGMATOR_BLOCK);
        this.dropSelf(BlocksRegistry.DIAMOND_MAGMATOR_BLOCK);
        this.dropSelf(BlocksRegistry.NETHERITE_MAGMATOR_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.COPPER_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.COPPER_PYLON_BLOCK);
        this.copyComponentWithEnable((DeferredHolder<Block, ? extends Block>)BlocksRegistry.COPPER_CELL_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.CELL_DATA);
        this.dropSelfWithEnable(BlocksRegistry.IRON_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.IRON_PYLON_BLOCK);
        this.copyComponentWithEnable((DeferredHolder<Block, ? extends Block>)BlocksRegistry.IRON_CELL_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.CELL_DATA);
        this.dropSelfWithEnable(BlocksRegistry.GOLD_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.GOLD_PYLON_BLOCK);
        this.copyComponentWithEnable((DeferredHolder<Block, ? extends Block>)BlocksRegistry.GOLD_CELL_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.CELL_DATA);
        this.dropSelfWithEnable(BlocksRegistry.DIAMOND_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.DIAMOND_PYLON_BLOCK);
        this.copyComponentWithEnable((DeferredHolder<Block, ? extends Block>)BlocksRegistry.DIAMOND_CELL_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.CELL_DATA);
        this.dropSelfWithEnable(BlocksRegistry.NETHERITE_PLINTH_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.NETHERITE_PYLON_BLOCK);
        this.copyComponentWithEnable((DeferredHolder<Block, ? extends Block>)BlocksRegistry.NETHERITE_CELL_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.CELL_DATA);
        this.dropSelfWithEnable(BlocksRegistry.HEART_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_UPGRADE_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CONNECT_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CTR_BASE_PRI_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.FACTORY_CTR_BASE_SEC_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.IMPORT_BLOCK);
        this.dropSelfWithEnable(BlocksRegistry.EXPORT_BLOCK);
        this.dropSelf(BlocksRegistry.LAYOUT_BLOCK);
        this.dropSelf(BlocksRegistry.CREATIVE_POWER_BLOCK);
        this.copyComponent((DeferredHolder<Block, ? extends Block>)BlocksRegistry.CREATIVE_TANK_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.CREATIVE_TANK_DATA);
        this.copyComponent((DeferredHolder<Block, ? extends Block>)BlocksRegistry.FLUID_INFUSER_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.FLUID_INFUSER_DATA);
        this.copyComponent((DeferredHolder<Block, ? extends Block>)BlocksRegistry.ITEM_INFUSER_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.ITEM_INFUSER_DATA);
        this.copyComponent((DeferredHolder<Block, ? extends Block>)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.ENCHANTED_LIQUIFIER_DATA);
        this.copyComponent((DeferredHolder<Block, ? extends Block>)BlocksRegistry.DYE_LIQUIFIER_BLOCK, (Supplier<? extends DataComponentType<?>>)ComponentsRegistry.DYE_LIQUIFIER_DATA);
    }

    public ResourceLocation getBlockResource(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public void dropSelf(DeferredHolder<Block, ? extends Block> block) {
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((Block)block.get()))).unwrap()));
    }

    public void dropSelfWithEnable(DeferredHolder<Block, ? extends Block> block) {
        LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)block.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.ENABLED, true));
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((Block)block.get())).when((LootItemCondition.Builder)builder))));
    }

    public void copyComponent(DeferredHolder<Block, ? extends Block> block, Supplier<? extends DataComponentType<?>> component) {
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().name(this.getBlockResource((Block)block.get()).toString()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((Block)block.get()).asItem()).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(component.get())))));
    }

    public void copyComponentWithEnable(DeferredHolder<Block, ? extends Block> block, Supplier<? extends DataComponentType<?>> component) {
        LootItemBlockStatePropertyCondition.Builder stateBuilder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)block.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.ENABLED, true));
        this.add((Block)block.get(), LootTables.noDrop().withPool(LootPool.lootPool().name(this.getBlockResource((Block)block.get()).toString()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)stateBuilder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((Block)block.get()).asItem()).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(component.get())))));
    }
}

