/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.WootCodecs;

public final class FluidInfuserData {
    public static final String ID = "fluid_infuser_data";
    public static final Codec<Component> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("Energy").forGetter(Component::energy), (App)FluidStack.OPTIONAL_CODEC.fieldOf("InputTank").forGetter(Component::inputFluid), (App)FluidStack.OPTIONAL_CODEC.fieldOf("OutputTank").forGetter(Component::outputFluid), (App)WootCodecs.MACHINE_PROPERTIES_CODEC.fieldOf("MachineProperties").forGetter(Component::listMachineProperties)).apply((Applicative)inst, Component::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Component::energy, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, Component::inputFluid, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, Component::outputFluid, WootCodecs.MACHINE_PROPERTIES_STREAM_CODEC, Component::listMachineProperties, Component::new);

    public record Component(int energy, @NotNull FluidStack inputFluid, @NotNull FluidStack outputFluid, List<EnumMap<MachineSide, MachineSideProperty>> listMachineProperties) {
        @Override
        public int hashCode() {
            return this.energy + FluidStack.hashFluidAndComponents((FluidStack)this.inputFluid) + FluidStack.hashFluidAndComponents((FluidStack)this.outputFluid) + this.listMachineProperties.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Component)) {
                return false;
            }
            Component c = (Component)obj;
            return c.energy == this.energy && FluidStack.isSameFluidSameComponents((FluidStack)c.inputFluid, (FluidStack)this.inputFluid) && FluidStack.isSameFluidSameComponents((FluidStack)c.outputFluid, (FluidStack)this.outputFluid) && c.listMachineProperties.equals(this.listMachineProperties);
        }
    }
}

