/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class FactoryUpgradeData {
    public static final String ID = "factory_upgrade_data";
    public static final Codec<Component> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("UpgradeItem").forGetter(Component::upgradeItem), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("UpgradeItemStack").forGetter(Component::upgradeStack)).apply((Applicative)inst, Component::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), Component::upgradeItem, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC), Component::upgradeStack, Component::new);

    public record Component(@NotNull Optional<String> upgradeItem, @NotNull Optional<ItemStack> upgradeStack) {
        @Override
        public int hashCode() {
            return this.upgradeItem.hashCode() + this.upgradeStack.map(ItemStack::hashItemAndComponents).orElse(0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            Optional<String> item;
            Optional<String> optional;
            if (!(obj instanceof Component)) return false;
            Component component = (Component)obj;
            try {
                item = optional = component.upgradeItem();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Optional<String> stack = optional = component.upgradeStack();
            if (!this.upgradeItem.equals(item)) return false;
            if (this.upgradeStack.map(s -> stack.filter(itemStack -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)itemStack)).isPresent()).orElse(stack.isEmpty()) == false) return false;
            return true;
        }
    }
}

