/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.WootCodecs;

public final class DyeLiquifierData {
    public static final String ID = "dye_liquifier_data";
    public static final Codec<Component> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("Energy").forGetter(Component::energy), (App)Codec.INT.fieldOf("Red").forGetter(Component::red), (App)Codec.INT.fieldOf("Yellow").forGetter(Component::yellow), (App)Codec.INT.fieldOf("Blue").forGetter(Component::blue), (App)Codec.INT.fieldOf("White").forGetter(Component::white), (App)FluidStack.OPTIONAL_CODEC.fieldOf("OutputTank").forGetter(Component::outputFluid), (App)WootCodecs.MACHINE_PROPERTIES_CODEC.fieldOf("MachineProperties").forGetter(Component::listMachineProperties)).apply((Applicative)inst, Component::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Component>(){

        public Component decode(RegistryFriendlyByteBuf buf) {
            int energy = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            int red = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            int yellow = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            int blue = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            int white = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            FluidStack outputFluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            List listMachineProperties = (List)WootCodecs.MACHINE_PROPERTIES_STREAM_CODEC.decode((Object)buf);
            return new Component(energy, red, yellow, blue, white, outputFluid, listMachineProperties);
        }

        public void encode(RegistryFriendlyByteBuf buf, Component component) {
            ByteBufCodecs.INT.encode((Object)buf, (Object)component.energy);
            ByteBufCodecs.INT.encode((Object)buf, (Object)component.red);
            ByteBufCodecs.INT.encode((Object)buf, (Object)component.yellow);
            ByteBufCodecs.INT.encode((Object)buf, (Object)component.blue);
            ByteBufCodecs.INT.encode((Object)buf, (Object)component.white);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)component.outputFluid);
            WootCodecs.MACHINE_PROPERTIES_STREAM_CODEC.encode((Object)buf, component.listMachineProperties);
        }
    };

    public record Component(int energy, int red, int yellow, int blue, int white, @NotNull FluidStack outputFluid, List<EnumMap<MachineSide, MachineSideProperty>> listMachineProperties) {
        @Override
        public int hashCode() {
            return this.energy + this.red + this.yellow + this.blue + this.white + FluidStack.hashFluidAndComponents((FluidStack)this.outputFluid) + this.listMachineProperties.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Component)) {
                return false;
            }
            Component c = (Component)obj;
            return c.energy == this.energy && c.red == this.red && c.yellow == this.yellow && c.blue == this.blue && c.white == this.white && FluidStack.isSameFluidSameComponents((FluidStack)c.outputFluid, (FluidStack)this.outputFluid) && c.listMachineProperties.equals(this.listMachineProperties);
        }
    }
}

