/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.kubejs.mobs;

import dev.latvian.mods.kubejs.event.KubeStartupEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.woot.compat.kubejs.mobs.KubeJSMob;
import wootrevived.woot.compat.kubejs.mobs.WootDropsPropertiesJS;
import wootrevived.woot.registries.WootFactoryMobsRegistry;

public class WootFactoryMobEventJS
implements KubeStartupEvent {
    private final WootFactoryMobRegistration registration;
    private final EntityType<?> entityType;

    public WootFactoryMobEventJS(WootFactoryMobRegistration registration, EntityType<?> entityType) {
        this.registration = registration;
        this.entityType = entityType;
    }

    public void registerDropsModifier(Consumer<WootDropsPropertiesJS> callback) {
        this.registration.registerDropsModifier(this.entityType, properties -> callback.accept(new WootDropsPropertiesJS((WootDropsProperties)properties)));
    }

    public void blacklistMob() {
        this.registration.registerFactoryMob(new WootFactoryMob(this.entityType, new WootFactoryMob.Properties().blacklist(true)));
    }

    public FactoryMobBuilderJS<?> factoryMobPatcher() {
        return new FactoryMobBuilderJS(this.registration, this.entityType);
    }

    public static class FactoryMobBuilderJS<T extends Entity> {
        private final WootFactoryMobRegistration registration;
        private final EntityType<T> entityType;
        private final WootFactoryMob<T> mob;
        private final WootFactoryMob.Properties properties;
        private final List<ItemStack> importItems = new ArrayList<ItemStack>();
        private final List<FluidStack> importFluids = new ArrayList<FluidStack>();
        private BiConsumer<String, WootDropsPropertiesJS> modifyDrops = null;

        public FactoryMobBuilderJS(WootFactoryMobRegistration registration, EntityType<T> entityType) {
            this.registration = registration;
            this.entityType = entityType;
            this.mob = WootFactoryMobsRegistry.hasFactoryMob(entityType) ? WootFactoryMobsRegistry.getFactoryMob(entityType) : new WootFactoryMob<T>(entityType, new WootFactoryMob.Properties());
            this.properties = new WootFactoryMob.Properties().blacklist(this.mob.isBlacklisted()).disabledSimulation(this.mob.isSimulationDisabled()).rate(this.mob.getSpawnTickRate()).vitalityCost(this.mob.getVitalityFuelCost()).tier(this.mob.getTier());
        }

        public void patch() {
            this.registration.registerFactoryMob(new KubeJSMob<T>(this.entityType, this.properties, this.mob, this.importItems, this.importFluids, this.modifyDrops));
        }

        public FactoryMobBuilderJS<T> modifyDrops(BiConsumer<String, WootDropsPropertiesJS> callback) {
            this.modifyDrops = callback;
            return this;
        }

        public FactoryMobBuilderJS<T> setImportItems(ItemStack[] items) {
            this.importItems.clear();
            this.importItems.addAll(Arrays.stream(items).toList());
            return this;
        }

        public FactoryMobBuilderJS<T> setImportFluids(FluidStack[] fluids) {
            this.importFluids.clear();
            this.importFluids.addAll(Arrays.stream(fluids).toList());
            return this;
        }

        public FactoryMobBuilderJS<T> blacklist(boolean isBlacklisted) {
            this.properties.blacklist(isBlacklisted);
            return this;
        }

        public FactoryMobBuilderJS<T> disabledSimulation(boolean isSimulationDisabled) {
            this.properties.disabledSimulation(isSimulationDisabled);
            return this;
        }

        public FactoryMobBuilderJS<T> rate(int spawnTickRate) {
            this.properties.rate(spawnTickRate);
            return this;
        }

        public FactoryMobBuilderJS<T> vitalityCost(int vitalityCost) {
            this.properties.vitalityCost(vitalityCost);
            return this;
        }

        public FactoryMobBuilderJS<T> tier(String tier) {
            this.properties.tier((Tier)StringRepresentable.fromEnum(Tier::values).byName(tier, (Enum)Tier.INVALID));
            return this;
        }
    }
}

