/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.kubejs.mobs;

import dev.latvian.mods.kubejs.event.KubeStartupEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.api.interfaces.WootDropsProperties;

public class WootDropsPropertiesJS
implements KubeStartupEvent {
    private final WootDropsProperties properties;

    public WootDropsProperties getRawProperties() {
        return this.properties;
    }

    public WootDropsPropertiesJS(WootDropsProperties properties) {
        this.properties = properties;
    }

    public int getEnchantmentLevel(String enchantmentId) {
        return this.getEnchantmentLevel(enchantmentId, "MAIN_HAND");
    }

    public int getEnchantmentLevel(String enchantmentId, String handId) {
        ItemStack stack;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        try {
            hand = InteractionHand.valueOf((String)handId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (hand) {
            default: {
                throw new MatchException(null, null);
            }
            case MAIN_HAND: {
                ItemStack itemStack = this.properties.getMainHandItem();
                break;
            }
            case OFF_HAND: {
                ItemStack itemStack = stack = this.properties.getOffHandItem();
            }
        }
        if (!stack.getItem().isEnchantable(stack)) {
            return 0;
        }
        HolderLookup.Provider lookupProvider = this.properties.getLookupProvider();
        HolderLookup.RegistryLookup lookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
        ResourceLocation id = ResourceLocation.tryParse((String)enchantmentId);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id);
        AtomicInteger enchantmentLevel = new AtomicInteger();
        lookup.get(key).ifPresent(enchantment -> enchantmentLevel.set(stack.getEnchantmentLevel((Holder)enchantment)));
        return enchantmentLevel.get();
    }

    public ItemStack[] getItemDrops() {
        List<ItemStack> stacks = this.properties.getItemDrops();
        return (ItemStack[])stacks.toArray(ItemStack[]::new);
    }

    public void setItemDrops(ItemStack[] items) {
        List<ItemStack> stacks = this.properties.getItemDrops();
        stacks.clear();
        stacks.addAll(Arrays.stream(items).toList());
    }

    public FluidStack[] getFluidDrops() {
        List<FluidStack> stacks = this.properties.getFluidDrops();
        return (FluidStack[])stacks.toArray(FluidStack[]::new);
    }

    public void setFluidDrops(FluidStack[] items) {
        List<FluidStack> stacks = this.properties.getFluidDrops();
        stacks.clear();
        stacks.addAll(Arrays.stream(items).toList());
    }

    public String getFactoryTier() {
        return this.properties.getFactoryTier().getSerializedName();
    }

    public RandomSource getRandom() {
        return this.properties.getRandom();
    }

    public int getExperience() {
        return this.properties.getExperience();
    }

    public void setExperience(int experience) {
        this.properties.setExperience(experience);
    }

    public float getLuck() {
        return this.properties.getLuck();
    }

    public boolean doSimulateChargedCreeper() {
        return this.properties.doSimulateChargedCreeper();
    }

    public boolean isEnderDragonAlreadyKilled() {
        return this.properties.isEnderDragonAlreadyKilled();
    }

    public boolean isInFire() {
        return this.properties.isInFire();
    }

    public String getDimension() {
        return this.properties.getDimension().location().toString();
    }
}

