/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.kubejs;

import dev.latvian.mods.kubejs.event.EventExit;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventTargetType;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.event.TargetedEventHandler;
import dev.latvian.mods.kubejs.script.ScriptType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.woot.compat.kubejs.mobs.WootDropsPropertiesJS;
import wootrevived.woot.compat.kubejs.mobs.WootFactoryMobEventJS;

public interface WootStartupEvents {
    public static final EventGroup GROUP = EventGroup.of((String)"WootStartupEvents");
    public static final TargetedEventHandler<ResourceLocation> MOBS = GROUP.startup("registerFactoryMob", () -> WootFactoryMobEventJS.class).requiredTarget(EventTargetType.ID.validator(WootStartupEvents::validateMob));
    public static final EventHandler DROPS = GROUP.startup("registerGlobalDropsModifier", () -> WootDropsPropertiesJS.class);

    private static boolean validateMob(Object o) {
        try {
            if (!(o instanceof ResourceLocation)) {
                return false;
            }
            ResourceLocation location = (ResourceLocation)o;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
            return entityType != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void postFactoryMobs(WootFactoryMobRegistration registration) {
        registration.registerGlobalDropsModifier(WootStartupEvents::postGlobalDropsModifier);
        MOBS.forEachListener(ScriptType.STARTUP, handler -> {
            if (handler.target == null) {
                throw new IllegalArgumentException("Event handler '" + String.valueOf(MOBS) + "' requires extra id!");
            }
            ResourceLocation location = (ResourceLocation)handler.target;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
            WootFactoryMobEventJS event = new WootFactoryMobEventJS(registration, entityType);
            try {
                handler.handle(ScriptType.STARTUP.console, MOBS, (KubeEvent)event);
            }
            catch (EventExit eventExit) {
            }
            catch (Throwable error) {
                ScriptType.STARTUP.console.error("Internal Error in '" + String.valueOf(MOBS) + "'", error);
            }
        });
    }

    public static void postGlobalDropsModifier(WootDropsProperties properties) {
        DROPS.post((KubeEvent)new WootDropsPropertiesJS(properties));
    }
}

