/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei.categories;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.compat.jei.WootJeiCustomFluidRenderer;
import wootrevived.woot.compat.jei.WootJeiPluginTypes;
import wootrevived.woot.config.ItemInfuserConfig;
import wootrevived.woot.events.client.GlobalClientTicker;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerScreen;

public class ItemInfuserRecipeCategory
implements IRecipeCategory<ItemInfuserRecipe> {
    private static IDrawable icon;
    private static final int GUI_WIDTH = 124;
    private static final int GUI_HEIGHT = 56;
    private static final int ENERGY_X = 0;
    private static final int ENERGY_Y = 0;
    private static final int INPUT_FLUID_X = 21;
    private static final int INPUT_FLUID_Y = 0;
    private static final int INGREDIENT_SLOT_X = 42;
    private static final int INGREDIENT_SLOT_Y = 19;
    private static final int AUGMENT_SLOT_X = 60;
    private static final int AUGMENT_SLOT_Y = 19;
    private static final int OUTPUT_SLOT_X = 106;
    private static final int OUTPUT_SLOT_Y = 19;
    private static final int PROGRESS_X = 81;
    private static final int PROGRESS_Y = 20;

    public ItemInfuserRecipeCategory(IGuiHelper guiHelper) {
        icon = guiHelper.createDrawableItemStack(((Item)BlocksRegistry.ITEM_INFUSER_BLOCK_ITEM.get()).getDefaultInstance());
    }

    public void draw(ItemInfuserRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        int totalProgressTick = recipe.getEnergy() / (Integer)ItemInfuserConfig.ENERGY_PROCESS_TRANSFER.get();
        int progress = GlobalClientTicker.tickCounter % totalProgressTick * 100 / totalProgressTick;
        WootContainerScreen.renderVanillaSlot(gui, 42, 19);
        WootContainerScreen.renderVanillaSlot(gui, 60, 19);
        WootContainerScreen.renderVanillaSlot(gui, 106, 19);
        WootContainerScreen.renderEnergyBg(gui, 0, 0);
        WootContainerScreen.renderFluidBg(gui, 21, 0);
        WootContainerScreen.renderProgressArrowBg(gui, 81, 20);
        WootContainerScreen.renderEnergy(gui, 0, 0, recipe.getEnergy(), (Integer)ItemInfuserConfig.ENERGY_CAPACITY.get());
        WootContainerScreen.renderProgressArrow(gui, 81, 20, progress);
        WootContainerScreen._renderEnergyTooltip(gui, (int)mouseX, (int)mouseY, 0, 0, recipe.getEnergy(), (Integer)ItemInfuserConfig.ENERGY_CAPACITY.get(), false, false);
        WootContainerScreen._renderProgressArrowTooltip(gui, (int)mouseX, (int)mouseY, 81, 20, progress, Math.max(0.0f, (float)totalProgressTick / 20.0f), (Integer)ItemInfuserConfig.ENERGY_PROCESS_TRANSFER.get(), false);
    }

    public int getWidth() {
        return 124;
    }

    public int getHeight() {
        return 56;
    }

    @NotNull
    public RecipeType<ItemInfuserRecipe> getRecipeType() {
        return WootJeiPluginTypes.ITEM_INFUSER_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.woot_revived.item_infuser.name");
    }

    @NotNull
    public IDrawable getIcon() {
        return icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ItemInfuserRecipe recipe, @NotNull IFocusGroup focuses) {
        FluidStack inputFluid = recipe.getFluid();
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 3).addFluidStack(inputFluid.getFluid(), (long)inputFluid.getAmount()).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new WootJeiCustomFluidRenderer((Integer)ItemInfuserConfig.INPUT_TANK_CAPACITY.get()));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(inputFluid.getFluid().getBucket().getDefaultInstance());
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 20).addIngredients(recipe.getIngredient());
        if (recipe.getAugment().isPresent()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 20).addIngredients(recipe.getAugment().get());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 107, 20).addItemStack(recipe.getOutput());
    }
}

