/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei.categories;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.client.render.fluid_infuser.FluidInfuserContainerScreen;
import wootrevived.woot.compat.jei.WootJeiCustomFluidRenderer;
import wootrevived.woot.compat.jei.WootJeiPluginTypes;
import wootrevived.woot.config.FluidInfuserConfig;
import wootrevived.woot.events.client.GlobalClientTicker;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerScreen;

public class FluidInfuserRecipeCategory
implements IRecipeCategory<FluidInfuserRecipe> {
    private static IDrawable icon;
    private static final int GUI_WIDTH = 129;
    private static final int GUI_HEIGHT = 56;
    private static final int ENERGY_X = 0;
    private static final int ENERGY_Y = 0;
    private static final int INPUT_SLOT_X = 66;
    private static final int INPUT_SLOT_Y = 5;
    private static final int INPUT_FLUID_X = 21;
    private static final int INPUT_FLUID_Y = 0;
    private static final int OUTPUT_FLUID_X = 111;
    private static final int OUTPUT_FLUID_Y = 0;
    private static final int PROGRESS_X = 43;
    private static final int PROGRESS_Y = 24;

    public FluidInfuserRecipeCategory(IGuiHelper guiHelper) {
        icon = guiHelper.createDrawableItemStack(((Item)BlocksRegistry.FLUID_INFUSER_BLOCK_ITEM.get()).getDefaultInstance());
    }

    public void draw(FluidInfuserRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        int totalProgressTick = recipe.getEnergy() / (Integer)FluidInfuserConfig.ENERGY_PROCESS_TRANSFER.get();
        int progress = GlobalClientTicker.tickCounter % totalProgressTick * 100 / totalProgressTick;
        WootContainerScreen.renderVanillaSlot(gui, 66, 5);
        WootContainerScreen.renderEnergyBg(gui, 0, 0);
        WootContainerScreen.renderFluidBg(gui, 21, 0);
        WootContainerScreen.renderFluidBg(gui, 111, 0);
        FluidInfuserContainerScreen.renderProgressBg(gui, 43, 24);
        WootContainerScreen.renderEnergy(gui, 0, 0, recipe.getEnergy(), (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get());
        FluidInfuserContainerScreen.renderProgress(gui, 43, 24, progress);
        WootContainerScreen._renderEnergyTooltip(gui, (int)mouseX, (int)mouseY, 0, 0, recipe.getEnergy(), (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get(), false, false);
        FluidInfuserContainerScreen._renderProgressTooltip(gui, (int)mouseX, (int)mouseY, 43, 24, progress, Math.max(0.0f, (float)totalProgressTick / 20.0f), (Integer)FluidInfuserConfig.ENERGY_PROCESS_TRANSFER.get(), false);
    }

    public int getWidth() {
        return 129;
    }

    public int getHeight() {
        return 56;
    }

    @NotNull
    public RecipeType<FluidInfuserRecipe> getRecipeType() {
        return WootJeiPluginTypes.FLUID_INFUSER_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.woot_revived.fluid_infuser.name");
    }

    @NotNull
    public IDrawable getIcon() {
        return icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidInfuserRecipe recipe, @NotNull IFocusGroup focuses) {
        FluidStack inputFluid = recipe.getInputFluid();
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 3).addFluidStack(inputFluid.getFluid(), (long)inputFluid.getAmount()).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new WootJeiCustomFluidRenderer((Integer)FluidInfuserConfig.INPUT_TANK_CAPACITY.get()));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(inputFluid.getFluid().getBucket().getDefaultInstance());
        builder.addSlot(RecipeIngredientRole.INPUT, 67, 6).addIngredients(recipe.getIngredient());
        FluidStack outputFluid = recipe.getOutputFluid();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 114, 3).addFluidStack(outputFluid.getFluid(), (long)outputFluid.getAmount()).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new WootJeiCustomFluidRenderer((Integer)FluidInfuserConfig.OUTPUT_TANK_CAPACITY.get()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(outputFluid.getFluid().getBucket().getDefaultInstance());
    }
}

